/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import org.simantics.browsing.ui.graph.contributor.labeler.LabelerContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.ui.modelBrowser.nodes.ComponentNode;

public class ComponentLabeler extends LabelerContributor<ComponentNode> {

	@Override
	public String getLabel(ReadGraph graph, ComponentNode node) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(graph);
		Resource resource = node.resource;
		String name = (String)
			graph.getPossibleRelatedValue(resource, b.HasName);
		if(name == null)
			name = resource.toString();
		ModelingResources mr = ModelingResources.getInstance(graph);
		if(!graph.hasStatement(resource, mr.ComponentToElement))
			name += " [POPULATE]";
		return name;
	}

}
