/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementatio
 *******************************************************************************/
package org.simantics.structural.ui.menuContributions;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.simantics.structural.ui.Activator;

/**
 * @author Tuukka Lehtonen
 */
public class LinkWithEditorContribution extends ActionContributionItem {

    public LinkWithEditorContribution(String preferenceKey) {
        this(preferenceKey, Activator.getDefault().getPreferenceStore());
    }

    public LinkWithEditorContribution(String preferenceKey, IPreferenceStore preferenceStore) {
        super(new LinkWithEditorAction(preferenceKey, preferenceStore));
    }

    public static class LinkWithEditorAction extends PreferenceCheckBoxAction {
        public LinkWithEditorAction(String preferenceKey, IPreferenceStore preferenceStore) {
            super("Link With Editor", preferenceKey, preferenceStore);
            setImageDescriptor(Activator.SYNCED_ICON);
        }
    }

}