/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.compositeViewer;

import java.util.HashMap;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Node;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class CreateCompositeGraph implements Read<Graph> {

	Resource composite;
	
	public CreateCompositeGraph(Resource composite) {
		this.composite = composite;
	}
	
	static class Connection {
		Node parent;
		String label;
		public Connection(Node parent, String label) {
			this.parent = parent;
			this.label = label;
		}	
	}

	private static String getName(ReadGraph g, Resource r) throws DatabaseException {
		String s = g.getPossibleRelatedValue(r, Layer0.getInstance(g).HasName);
		if (s == null)
			s = NameUtils.getSafeName(g, r);
		return s;
	}
	
	Graph graph;
	HashMap<Resource, Node> connections = new HashMap<Resource, Node>();
	
	private void connect(Node parent, String label, Resource connection) {
		Node cn = connections.get(connection);
		if(cn == null) {
			cn = new Node(graph);
			cn.setShape("diamond");
			cn.setFixedSize(true);
			cn.setWidth(0.2);
			cn.setHeight(0.2);
			connections.put(connection, cn);
		}
		Edge edge = new Edge(parent, cn);
		edge.setArrowhead("none");
		if(label.contains("Self"))
			edge.setColor("red");
		else
			edge.setTailLabel(label);
		edge.set("fontsize", "8");
	}
	
	@Override
	public Graph perform(ReadGraph g) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(g);
		StructuralResource2 STR = StructuralResource2.getInstance(g);
		
		graph = new Graph();
		graph.set("overlap", "false");
		graph.set("splines", "true");
		
		for(Resource child : g.getObjects(composite, L0.ConsistsOf)) {
			Node node = new Node(graph, getName(g, child));
			node.setShape("rect");
			if(g.isInstanceOf(child, STR.Composite)) {
				for(Resource c : g.getObjects(child, STR.HasConnectionJoin))
					connect(node, "", c);
			}
			else {
				for(Statement stat : g.getStatements(child, STR.IsConnectedTo)) {
					String label = getName(g, stat.getPredicate());					
					connect(node, label, stat.getObject());
				}
			}
		}
		
		Graph rgraph = graph;
		graph = null;
		connections.clear();
		
		return rgraph;
	}

}
