/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.utils;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.simantics.structural.synchronization.utils.ComponentBase;
import org.simantics.structural.synchronization.utils.ComponentFactory;
import org.simantics.structural.synchronization.utils.Solver;
import org.simantics.structural.synchronization.utils.StateUndoContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MappingBase<T extends ComponentBase<T>> {
    private final transient Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected transient THashMap<String, T> configurationByUid;
    protected transient Map<String, T> configurationBySolverName;
    protected transient TIntObjectMap<T> configurationByComponentId;
    transient THashSet<T> pendingRemoval = new THashSet();
    public transient StateUndoContextBase undoContext = this.createUndoContext();
    public transient ComponentFactory<T> componentFactory = this.createComponentFactory();
    public long currentRevision;
    private boolean trustUids;

    public abstract T getConfiguration();

    public MappingBase() {
        this(null, -1L, false);
    }

    public MappingBase(T configuration, boolean trustUids) {
        this(configuration, -1L, trustUids);
    }

    public MappingBase(T configuration, long currentRevision, boolean trustUids) {
        if (trustUids) {
            this.createConfigurationById(configuration);
        }
        this.currentRevision = currentRevision;
        this.trustUids = trustUids;
    }

    public abstract StateUndoContextBase createUndoContext();

    public abstract ComponentFactory<T> createComponentFactory();

    protected void createConfigurationById(T configuration) {
        THashMap configurationByUid = new THashMap();
        this.browseConfiguration(configurationByUid, configuration);
        this.configurationByUid = configurationByUid;
    }

    private void browseConfiguration(THashMap<String, T> configurationByUid, T configuration) {
        configurationByUid.put((Object)((ComponentBase)configuration).uid, configuration);
        THashMap children = ((ComponentBase)configuration).getChildMap();
        if (children != null) {
            children.forEachValue(child -> {
                this.browseConfiguration(configurationByUid, child);
                child.parent = configuration;
                return true;
            });
        }
    }

    public Map<String, T> getConfigurationBySolverName() {
        Map<String, Object> result = this.configurationBySolverName;
        if (result == null) {
            T configuration = this.getConfiguration();
            if (configuration != null) {
                Object[] t = this.createConfigurationCacheMaps(configuration);
                return (Map)t[0];
            }
            result = Collections.emptyMap();
        }
        return result;
    }

    public TIntObjectMap<T> getConfigurationByComponentId() {
        TIntObjectHashMap result = this.configurationByComponentId;
        if (result == null) {
            T configuration = this.getConfiguration();
            if (configuration != null) {
                Object[] t = this.createConfigurationCacheMaps(configuration);
                return (TIntObjectMap)t[1];
            }
            result = new TIntObjectHashMap(1);
        }
        return result;
    }

    protected Object[] createConfigurationCacheMaps(T configuration) {
        THashMap configurationBySolverName = new THashMap();
        TIntObjectHashMap configurationByComponentId = new TIntObjectHashMap();
        this.browseConfigurationCacheMaps((THashMap<String, T>)configurationBySolverName, (TIntObjectMap<T>)configurationByComponentId, configuration);
        this.configurationBySolverName = configurationBySolverName;
        this.configurationByComponentId = configurationByComponentId;
        return new Object[]{configurationBySolverName, configurationByComponentId};
    }

    private void browseConfigurationCacheMaps(THashMap<String, T> configurationBySolverName, TIntObjectMap<T> configurationByComponentId, T configuration) {
        if (((ComponentBase)configuration).solverComponentName != null) {
            configurationBySolverName.put((Object)((ComponentBase)configuration).solverComponentName, configuration);
            configurationByComponentId.put(((ComponentBase)configuration).componentId, configuration);
        } else if (((ComponentBase)configuration).componentId != 0) {
            this.LOGGER.warn("configuration.solverComponentName is null! configuration uid is {} and component id {}", (Object)((ComponentBase)configuration).getUid(), (Object)((ComponentBase)configuration).componentId);
        }
        for (ComponentBase child : ((ComponentBase)configuration).getChildren()) {
            this.browseConfigurationCacheMaps(configurationBySolverName, configurationByComponentId, child);
        }
    }

    public T detachOrCreateComponent(String uid) {
        ComponentBase result = (ComponentBase)this.configurationByUid.get((Object)uid);
        if (result == null) {
            result = this.componentFactory.create(uid);
            this.configurationByUid.put((Object)uid, (Object)result);
            this.configurationBySolverName = null;
            this.configurationByComponentId = null;
        } else if (result.getParent() == null) {
            this.pendingRemoval.remove((Object)result);
        } else {
            ((ComponentBase)result.getParent()).detachByUid(uid);
        }
        return (T)result;
    }

    public void changeSolverName(T component, String newSolverName) {
        if (Objects.equals(((ComponentBase)component).solverComponentName, newSolverName)) {
            return;
        }
        if (this.configurationBySolverName != null) {
            ComponentBase cachedComponent;
            String oldSolverName = ((ComponentBase)component).solverComponentName;
            if (newSolverName != null && this.configurationBySolverName.containsKey(newSolverName)) {
                throw new IllegalStateException("Target solver component name " + newSolverName + " already exists, cannot rename from " + oldSolverName);
            }
            if (oldSolverName != null && (cachedComponent = (ComponentBase)this.configurationBySolverName.get(oldSolverName)) != null) {
                if (cachedComponent != component) {
                    throw new IllegalStateException("Old name of component " + oldSolverName + " is not mapped to the provided component (provided=" + String.valueOf(component) + ", cached=" + String.valueOf(cachedComponent) + ")");
                }
                this.configurationBySolverName.remove(oldSolverName);
            }
            if (newSolverName != null) {
                this.configurationBySolverName.put(newSolverName, component);
            }
        }
        ((ComponentBase)component).solverComponentName = newSolverName;
    }

    public void invalidateSolverNameCache() {
        this.configurationBySolverName = null;
    }

    public void addPendingRemoval(T component) {
        this.pendingRemoval.add(component);
    }

    public void printUidMap() {
        this.printUidMap(new PrintWriter(System.out));
    }

    public void printUidMap(final PrintWriter out) {
        out.println("Component tree");
        out.print("    ");
        ((ComponentBase)this.getConfiguration()).printConfiguration(out, 1);
        if (this.configurationByUid != null) {
            out.println("UIDs");
            this.configurationByUid.forEachEntry(new TObjectObjectProcedure<String, T>(){

                public boolean execute(String a, T b) {
                    out.println("    " + a + " (" + ((ComponentBase)b).solverComponentName + ", " + ((ComponentBase)b).componentId + ", " + ((ComponentBase)b).uid + ")");
                    return true;
                }
            });
        }
    }

    public void remove(final Solver solver, T component) {
        if (this.configurationByUid != null) {
            this.configurationByUid.remove((Object)((ComponentBase)component).uid);
        }
        if (this.configurationBySolverName != null && ((ComponentBase)component).solverComponentName != null) {
            this.configurationBySolverName.remove(((ComponentBase)component).solverComponentName);
        }
        if (this.configurationByComponentId != null && ((ComponentBase)component).componentId != 0) {
            this.configurationByComponentId.remove(((ComponentBase)component).componentId);
        }
        if (((ComponentBase)component).getChildMap() != null) {
            ((ComponentBase)component).getChildMap().forEachValue(new TObjectProcedure<T>(){

                public boolean execute(T child) {
                    MappingBase.this.remove(solver, child);
                    return true;
                }
            });
        }
        if (((ComponentBase)component).componentId > 0 && !((ComponentBase)component).attached) {
            solver.remove(component);
        }
    }

    public void saveUndoState(final Solver solver, T component) {
        if (((ComponentBase)component).getChildMap() != null) {
            ((ComponentBase)component).getChildMap().forEachValue(new TObjectProcedure<T>(){

                public boolean execute(T child) {
                    MappingBase.this.saveUndoState(solver, child);
                    return true;
                }
            });
        } else if (((ComponentBase)component).componentId > 0 && !((ComponentBase)component).attached) {
            this.undoContext.saveState(solver, ((ComponentBase)component).componentId, ((ComponentBase)component).uid);
        }
    }

    public void removePending(final Solver solver) {
        this.pendingRemoval.forEach(new TObjectProcedure<T>(){

            public boolean execute(T component) {
                MappingBase.this.saveUndoState(solver, component);
                return true;
            }
        });
        this.pendingRemoval.forEach(new TObjectProcedure<T>(){

            public boolean execute(T component) {
                MappingBase.this.remove(solver, component);
                return true;
            }
        });
        this.pendingRemoval.clear();
    }

    public void setTrustUids(boolean trustUids) {
        if (trustUids != this.trustUids) {
            T configuration;
            this.trustUids = trustUids;
            if (trustUids && (configuration = this.getConfiguration()) != null) {
                this.createConfigurationById(configuration);
            }
        }
        if (!trustUids) {
            this.configurationByUid = null;
        }
    }

    public boolean getTrustUids() {
        return this.trustUids;
    }

    public void dispose() {
        if (this.configurationByUid != null) {
            this.configurationByUid.clear();
        }
        if (this.configurationBySolverName != null) {
            this.configurationBySolverName.clear();
            this.configurationBySolverName = null;
        }
        if (this.configurationByComponentId != null) {
            this.configurationByComponentId.clear();
            this.configurationByComponentId = null;
        }
        this.pendingRemoval.clear();
    }

    public boolean hasPendingRemovals() {
        return !this.pendingRemoval.isEmpty();
    }

    public void forEachPendingRemoval(Consumer<T> consumer) {
        this.pendingRemoval.forEach(c -> {
            consumer.accept(c);
            return true;
        });
    }
}

