package org.simantics.structural.synchronization.utils;

public interface Solver {

	public int getId(String name);
	public String getName(int id);
	public int getModuleType(int id);
	
	public void remove(int id);
	public default <T extends ComponentBase<T>> void remove(T component) {
		remove(component.componentId);
	}
	
	public void addSubprocess(String name, String subprocessType);
	public void includeSubprocess(String parentName, String subprocessName);
	
	public <T> T getConcreteSolver();
	
}
