/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver.formula;

import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.simantics.spreadsheet.solver.formula.CellFormulaFunction;
import org.simantics.spreadsheet.solver.formula.CellValueVisitor;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class YearFormulaFunction
implements CellFormulaFunction<Long> {
    private Temporal baseline = LocalDate.of(1899, Month.DECEMBER, 30);

    @Override
    public Long evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 1) {
            throw new IllegalStateException();
        }
        Object condition = args.values.get(0).accept(visitor);
        if (condition instanceof Long) {
            Temporal t = ChronoUnit.DAYS.addTo(this.baseline, (Long)condition);
            Year y = Year.from(t);
            return y.getValue();
        }
        throw new IllegalStateException();
    }
}

