/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableName;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.request.VariableRepresents;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.graph.GraphUI;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.spreadsheet.ui.editor.ExcelLink;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.ResourceEditorPart2;
import org.simantics.utils.ui.LayoutUtils;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SpreadsheetEditor2
extends ResourceEditorPart2 {
    public static final boolean EXCEL = false;
    public static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor2";
    private Spreadsheet spreadsheet;
    private final ActiveSelectionProvider selectionProvider = new ActiveSelectionProvider();
    private ExcelLink excelLink;
    private GraphUI ui;

    public Spreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.ui = new GraphUI((RequestProcessor)this.getSession());
        try {
            Variable bookVariable = (Variable)this.getSession().syncRequest((Read)new Read<Variable>(){

                public Variable perform(ReadGraph graph) throws DatabaseException {
                    Resource book = SpreadsheetEditor2.this.getResourceInput2().getResource();
                    Variable withContext = SpreadsheetUtils.getBookVariable((ReadGraph)graph, (Resource)book);
                    return withContext;
                }
            });
            Variable sheetVariable = (Variable)this.getSession().syncRequest((Read)new VariableRead<Variable>(bookVariable){

                public Variable perform(ReadGraph graph) throws DatabaseException {
                    SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
                    Collection children = this.variable.getChildren(graph);
                    if (children.isEmpty()) {
                        return null;
                    }
                    TreeMap<String, Variable> names = new TreeMap<String, Variable>();
                    for (Variable child : children) {
                        Resource type = child.getPossibleType(graph, SR.Spreadsheet);
                        if (type == null) continue;
                        names.put(child.getName(graph), child);
                    }
                    return (Variable)names.firstEntry().getValue();
                }
            });
            String uri = (String)this.getSession().syncRequest((Read)new VariableURI(sheetVariable));
            Resource book = (Resource)this.getSession().syncRequest((Read)new VariableRepresents(bookVariable));
            Resource sheet = (Resource)this.getSession().syncRequest((Read)new VariableRepresents(sheetVariable));
            String sheetName = (String)this.getSession().syncRequest((Read)new VariableName(sheetVariable));
            String bookName = (String)this.getSession().syncRequest((Read)new VariableName(bookVariable));
            this.spreadsheet = new Spreadsheet(parent, 0, (Adaptable)this.ui, this.selectionProvider);
            this.spreadsheet.setBackground(parent.getDisplay().getSystemColor(1));
            this.excelLink = new ExcelLink(this.getSession(), sheet, this.spreadsheet.getClientModel(), book, bookName, sheetName, uri);
            this.ui.load(sheetVariable, this.spreadsheet.getClientInterface());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return;
        }
        this.spreadsheet.setLayoutData(new GridData(4, 4, true, true));
        this.spreadsheet.defaultInitializeUI();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.activateValidation();
        IContextService contexts = (IContextService)this.getSite().getService(IContextService.class);
        contexts.activateContext("org.simantics.spreadsheet.ui.context");
    }

    public void setFocus() {
        if (this.spreadsheet != null) {
            this.spreadsheet.setFocus();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertyPage.class) {
            return new StandardPropertyPage(this.getSite(), Collections.singleton("http://www.simantics.org/Spreadsheet-1.2/BrowseContext"));
        }
        if (adapter == GraphUI.class) {
            return this.ui;
        }
        if (adapter == Spreadsheet.class) {
            return this.getSpreadsheet();
        }
        return null;
    }

    public void dispose() {
        this.ui.dispose();
        super.dispose();
    }
}

