/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.excel.Excel;
import org.simantics.excel.ExcelException;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.CellParseException;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.common.client.ClientModelListenerAdapter;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class ExcelLink
extends ClientModelListenerAdapter {
    private final Session session;
    private final Resource container;
    private final ClientModel model;
    private final Resource book;
    private final String bookName;
    private final String sheetName;
    private final String prefix;
    private final Excel excel;
    private int handle;

    public ExcelLink(Session session, Resource container, ClientModel model, Resource book, String bookName, String sheetName, String prefix) {
        this.session = session;
        this.container = container;
        this.handle = 0;
        this.model = model;
        this.bookName = bookName + ".xlsx";
        this.sheetName = sheetName;
        this.prefix = prefix;
        this.book = book;
        this.excel = ExcelLink.tryGetExcel(book, bookName);
        model.addListener((ClientModel.ClientModelListener)this);
    }

    public static Excel tryGetExcel(final Resource book, String bookName) {
        try {
            Excel excel = Excel.getInstance((PrintStream)System.out);
            String file = excel.getFile(bookName);
            File tester = new File(file);
            if (!tester.exists()) {
                try {
                    byte[] saved = (byte[])Simantics.getSession().syncRequest((Read)new ResourceRead<byte[]>(book){

                        public byte[] perform(ReadGraph graph) throws DatabaseException {
                            SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
                            return (byte[])graph.getPossibleRelatedValue(book, SR.HasMicrosoftExcelDocumentData, (Binding)Bindings.BYTE_ARRAY);
                        }
                    });
                    if (saved != null) {
                        FileUtils.writeFile((File)tester, (byte[])saved);
                    }
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                catch (IOException e) {
                    Logger.defaultLogError((Throwable)e);
                }
            }
            return excel;
        }
        catch (ExcelException e1) {
            Logger.defaultLogError((Throwable)e1);
            return null;
        }
    }

    public void dispose() {
        this.model.removeListener((ClientModel.ClientModelListener)this);
        try {
            if (this.excel != null) {
                byte[] saved;
                String file;
                File tester;
                if (this.handle != 0) {
                    this.excel.close_(this.handle);
                }
                if ((tester = new File(file = this.excel.getFile(this.bookName))).exists() && (saved = FileUtils.readFile((File)tester)) != null) {
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
                            graph.claimLiteral(ExcelLink.this.book, SR.HasMicrosoftExcelDocumentData, (Object)saved, (Binding)Bindings.BYTE_ARRAY);
                        }
                    });
                }
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public void propertyChange(String location, String property, Object value) {
        block19: {
            if ("content".equals(property) && value != null && value instanceof Variant) {
                if (this.handle == 0) {
                    return;
                }
                Range range = Spreadsheets.decodeCellAbsolute((String)location);
                this.excel.setString_(this.handle, range.startRow, range.startColumn, ((Variant)value).getValue().toString());
                final String modis = this.excel.getModifications_(this.handle);
                this.session.asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        String[] parts = (modis + "0").split("#");
                        Range range = Spreadsheets.decodeRange((String)parts[0]);
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                        int index = 1;
                        int i = 0;
                        while (i < range.height()) {
                            int j = 0;
                            while (j < range.width()) {
                                String addr = Spreadsheets.cellName((int)(range.startRow + i), (int)(range.startColumn + j));
                                String content = parts[index++];
                                Resource cell = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)ExcelLink.this.container, (String)addr);
                                if (cell != null) {
                                    Variant existing;
                                    Variant newValue = Variant.ofInstance((Object)content);
                                    if (!newValue.equals((Object)(existing = (Variant)graph.getRelatedValue(cell, SHEET.Cell_content, (Binding)Bindings.VARIANT)))) {
                                        graph.claimLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, (Object)newValue, (Binding)Bindings.VARIANT);
                                    }
                                } else {
                                    cell = graph.newResource();
                                    graph.claim(cell, L0.InstanceOf, null, SHEET.TextCell);
                                    graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, (Object)addr, (Binding)Bindings.STRING);
                                    graph.addLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)content), (Binding)Bindings.VARIANT);
                                    graph.claim(cell, L0.PartOf, ExcelLink.this.container);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        i = 1;
                        while (i < parts.length) {
                            ++i;
                        }
                    }
                });
            } else if ("Excel".equals(location) && "Visible".equals(property) && value instanceof Boolean) {
                Boolean visible = (Boolean)value;
                if (visible.booleanValue()) {
                    try {
                        Range range;
                        if (this.handle != 0) break block19;
                        Excel excel = Excel.getInstance((PrintStream)System.out);
                        String file = excel.getFile(this.bookName);
                        FileUtils.ensureParentDirectoryExists((String)file);
                        String sheetName2 = (this.bookName + "_" + this.sheetName).substring(0, 30).replace(".", "_");
                        String handleString = excel.open_(file, sheetName2);
                        try {
                            this.handle = Integer.valueOf(handleString);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ShowMessage.showError((String)"Problems with Excel", (String)handleString);
                            Logger.defaultLogError((Throwable)new RuntimeException(handleString));
                            return;
                        }
                        for (Pair label : this.model.listAll("label")) {
                            try {
                                range = Spreadsheets.decodeCellAbsolute((String)((String)label.first));
                                excel.setString_(this.handle, range.startRow, range.startColumn, (String)label.second);
                            }
                            catch (CellParseException cellParseException) {}
                        }
                        for (Pair label : this.model.listAll("content")) {
                            try {
                                range = Spreadsheets.decodeCellAbsolute((String)((String)label.first));
                                String uri = (String)label.second;
                                if (!uri.startsWith(this.prefix)) continue;
                                String rvi = uri.substring(this.prefix.length() + 1).replace("#", "_").replace("(", "_").replace(")", "_").replace("+", "p").replace("-", "m");
                                excel.setName_(this.handle, range.startRow, range.startColumn, rvi);
                            }
                            catch (CellParseException cellParseException) {}
                        }
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                } else {
                    try {
                        if (this.handle != 0) {
                            Excel excel = Excel.getInstance((PrintStream)System.out);
                            this.handle = excel.close_(this.handle);
                            this.handle = 0;
                        }
                    }
                    catch (Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                }
            }
        }
    }
}

