/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.spreadsheet.ui.ITrackedColorProvider;
import org.simantics.spreadsheet.ui.TrackedModifyEvent;
import org.simantics.spreadsheet.ui.TrackedModifyListener;

public class TrackedText {
    private static final boolean EVENT_DEBUG = false;
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private static final int MOUSE_INSIDE_CONTROL = 8;
    private int state;
    private int caretPositionBeforeEdit;
    private String textBeforeEdit;
    private JTextField text;
    private CompositeListener listener;
    private ListenerList modifyListeners;
    private IInputValidator validator;
    private ITrackedColorProvider colorProvider;

    public TrackedText(JTextField text) {
        Assert.isNotNull((Object)text);
        this.state = 0;
        this.text = text;
        this.colorProvider = new DefaultColorProvider();
        this.initialize();
    }

    public TrackedText(JTextField text, ITrackedColorProvider colorProvider) {
        Assert.isNotNull((Object)text, (String)"text must not be null");
        Assert.isNotNull((Object)colorProvider, (String)"colorProvider must not be null");
        this.state = 0;
        this.text = text;
        this.colorProvider = colorProvider;
        this.initialize();
    }

    private void initialize() {
        Assert.isNotNull((Object)this.text);
        this.listener = new CompositeListener();
        this.text.addActionListener(this.listener);
        this.text.addCaretListener(this.listener);
        this.text.addAncestorListener(this.listener);
        this.text.addComponentListener(this.listener);
        this.text.addContainerListener(this.listener);
        this.text.addFocusListener(this.listener);
        this.text.addHierarchyBoundsListener(this.listener);
        this.text.addHierarchyListener(this.listener);
        this.text.addInputMethodListener(this.listener);
        this.text.addKeyListener(this.listener);
        this.text.addMouseListener(this.listener);
        this.text.addMouseMotionListener(this.listener);
        this.text.addMouseWheelListener(this.listener);
        this.text.addPropertyChangeListener(this.listener);
        this.text.addVetoableChangeListener(this.listener);
    }

    private void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            System.out.println("TrackedText: BUG: startEdit called when in editing state");
        }
        this.caretPositionBeforeEdit = this.text.getCaretPosition();
        this.textBeforeEdit = this.text.getText();
        this.setBackground(this.colorProvider.getEditingBackground());
        if (selectAll) {
            this.text.selectAll();
        }
        this.state |= 5;
    }

    private void applyEdit() {
        try {
            if (this.isTextValid() != null) {
                this.text.setText(this.textBeforeEdit);
            } else if (this.isModified() && !this.text.getText().equals(this.textBeforeEdit) && this.modifyListeners != null) {
                TrackedModifyEvent event = new TrackedModifyEvent(this.text, this.text.getText());
                Object[] objectArray = this.modifyListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((TrackedModifyListener)o).modifyText(event);
                    ++n2;
                }
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void endEdit() {
        this.isEditing();
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.text.setCaretPosition(this.text.getText().length());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: revertEdit called when not in editing state");
        }
        this.text.setText(this.textBeforeEdit);
        this.text.setCaretPosition(this.caretPositionBeforeEdit);
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isMouseInsideControl() {
        return (this.state & 8) != 0;
    }

    private void setMouseInsideControl(boolean inside) {
        this.state = inside ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    private boolean isModified() {
        return (this.state & 2) != 0;
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.text.setEditable(true);
            this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        } else {
            this.text.setEditable(false);
            this.text.setBackground(null);
        }
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void setTextWithoutNotify(String text) {
        this.setText(text);
    }

    public JTextField getWidget() {
        return this.text;
    }

    public synchronized void addModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add((Object)listener);
    }

    public synchronized void removeModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove((Object)listener);
    }

    public void setInputValidator(IInputValidator validator) {
        if (validator != this.validator) {
            this.validator = validator;
        }
    }

    private String isTextValid() {
        if (this.validator != null) {
            return this.validator.isValid(this.getWidget().getText());
        }
        return null;
    }

    public void setColorProvider(ITrackedColorProvider provider) {
        Assert.isNotNull((Object)provider);
        this.colorProvider = provider;
    }

    private void setBackground(Color background) {
        if (!this.text.isEditable()) {
            return;
        }
        this.text.setBackground(background);
    }

    private class CompositeListener
    implements ActionListener,
    CaretListener,
    AncestorListener,
    ComponentListener,
    ContainerListener,
    FocusListener,
    HierarchyBoundsListener,
    HierarchyListener,
    InputMethodListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    PropertyChangeListener,
    VetoableChangeListener {
        private CompositeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }

        @Override
        public void caretUpdate(CaretEvent arg0) {
        }

        @Override
        public void ancestorAdded(AncestorEvent arg0) {
        }

        @Override
        public void ancestorMoved(AncestorEvent arg0) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent arg0) {
        }

        @Override
        public void componentHidden(ComponentEvent arg0) {
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }

        @Override
        public void componentAdded(ContainerEvent arg0) {
        }

        @Override
        public void componentRemoved(ContainerEvent arg0) {
        }

        @Override
        public void focusGained(FocusEvent arg0) {
            if (!TrackedText.this.isEditing()) {
                TrackedText.this.startEdit(false);
            }
        }

        @Override
        public void focusLost(FocusEvent arg0) {
        }

        @Override
        public void ancestorMoved(HierarchyEvent arg0) {
        }

        @Override
        public void ancestorResized(HierarchyEvent arg0) {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent arg0) {
        }

        @Override
        public void caretPositionChanged(InputMethodEvent arg0) {
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent arg0) {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
            if (arg0.getKeyCode() == 27) {
                TrackedText.this.revertEdit();
            }
            if (arg0.getKeyCode() == 10) {
                TrackedText.this.applyEdit();
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
            TrackedText.this.setModified(true);
            if (!TrackedText.this.isEditing()) {
                TrackedText.this.startEdit(false);
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent arg0) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent arg0) throws PropertyVetoException {
        }
    }

    private class DefaultColorProvider
    implements ITrackedColorProvider {
        private Color editingColor = new Color(255, 255, 255);

        private DefaultColorProvider() {
        }

        @Override
        public Color getEditingBackground() {
            return this.editingColor;
        }

        @Override
        public Color getHoverBackground() {
            return null;
        }

        @Override
        public Color getInactiveBackground() {
            return null;
        }

        @Override
        public Color getInvalidBackground() {
            return null;
        }

        void dispose() {
        }
    }
}

