/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.ui.SpreadsheetCellEditor;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

class TextTableCellEditor
extends DefaultCellEditor
implements SpreadsheetCellEditor {
    final int row;
    final int column;
    final CellEditor<?> editor;
    final String initial;
    private static final long serialVersionUID = 8039248821751464832L;
    JTextField ftf;
    ClientModel clientModel;

    public TextTableCellEditor(int row, int column, String initial, CellEditor<?> editor, ClientModel clientModel) {
        super(new JTextField());
        assert (editor != null);
        this.row = row;
        this.column = column;
        this.initial = initial == null ? "" : initial;
        this.editor = editor;
        this.clientModel = clientModel;
        this.ftf = (JTextField)this.getComponent();
        this.ftf.setHorizontalAlignment(11);
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (super.isCellEditable(event)) {
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                int kc = ke.getKeyCode();
                switch (kc) {
                    case 27: {
                        return false;
                    }
                    case 113: {
                        return true;
                    }
                }
                if (ke.isActionKey()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JTextField ftf = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setText(this.initial);
        ftf.selectAll();
        ftf.setFont(ftf.getFont().deriveFont(AffineTransform.getScaleInstance(0.8, 0.8)));
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JTextField ftf = (JTextField)this.getComponent();
        return ftf.getText();
    }

    protected boolean userSaysRevert() {
        Toolkit.getDefaultToolkit().beep();
        this.ftf.selectAll();
        Object[] options = new Object[]{"Edit", "Revert"};
        int answer = JOptionPane.showOptionDialog(SwingUtilities.getWindowAncestor(this.ftf), "The value must be an integer between You can either continue editing or revert to the last valid value.", "Invalid Text Entered", 0, 0, null, options, options[1]);
        if (answer == 1) {
            this.ftf.setText(this.ftf.getText());
            return true;
        }
        return false;
    }

    @Override
    public void commit() {
        Variant content;
        String str = (String)this.getCellEditorValue();
        String cellName = Spreadsheets.cellName((int)this.row, (int)this.column);
        Object expressionO = this.clientModel.getPossiblePropertyAt(cellName, "content#expression");
        Object expression = null;
        if (expressionO instanceof String) {
            expression = (String)expressionO;
        } else if (expressionO instanceof Variant) {
            expression = ((Variant)expressionO).getValue().toString();
        }
        expression = expression == null ? ((content = SpreadsheetUtils.getSafeClientVariant((ClientModel)this.clientModel, (String)cellName, (String)"content")) != null ? content.getValue().toString() : "") : "=" + (String)expression;
        if (((String)expression).equals(str)) {
            return;
        }
        if (str.startsWith("=")) {
            this.editor.edit(null, Spreadsheets.cellName((int)this.row, (int)this.column), "content#expression", Variant.ofInstance((Object)str), null);
            this.clientModel.setProperty(cellName, "content#expression", (Object)str);
        } else {
            this.editor.edit(null, Spreadsheets.cellName((int)this.row, (int)this.column), "content", Variant.ofInstance((Object)str), null);
            this.clientModel.setProperty(cellName, "content#expression", null);
        }
    }
}

