/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import org.simantics.spreadsheet.ui.DefaultLookup;

public class TableBorder
extends AbstractBorder {
    private static final long serialVersionUID = -2732591061826521471L;
    private static Border blackLine;
    private static Border grayLine;
    protected int thickness;
    protected Color lineColor;
    protected boolean roundedCorners;
    public static final TableBorder BORDER;

    static {
        BORDER = new TableBorder(DefaultLookup.BORDER, 0);
    }

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new TableBorder(Color.black, 1);
        }
        return blackLine;
    }

    public static Border createGrayLineBorder() {
        if (grayLine == null) {
            grayLine = new TableBorder(Color.gray, 1);
        }
        return grayLine;
    }

    public TableBorder(Color color) {
        this(color, 1, false);
    }

    public TableBorder(Color color, int thickness) {
        this(color, thickness, false);
    }

    public TableBorder(Color color, int thickness, boolean roundedCorners) {
        this.lineColor = color;
        this.thickness = thickness;
        this.roundedCorners = roundedCorners;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        g.drawLine(1, height - 1, 1 + width - 1, height - 1);
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.right = insets.bottom = this.thickness;
        insets.top = insets.bottom;
        insets.left = insets.bottom;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    public boolean getRoundedCorners() {
        return this.roundedCorners;
    }

    @Override
    public boolean isBorderOpaque() {
        return !this.roundedCorners;
    }
}

