/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.OperationMode;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.Transaction;
import org.simantics.spreadsheet.common.cell.StringCellParser;
import org.simantics.spreadsheet.ui.CellValue;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ExcelAdapter
implements ActionListener {
    private final JTable table;
    private final ClientModel model;
    private final CellEditor editor;
    private static final Pattern newline = Pattern.compile("\n");
    private static final Pattern tab = Pattern.compile("\t");
    private final StringCellParser[] parsers;
    private Object clipboard = null;
    private ClipboardOwner clipboardOwner = null;
    private String rowstring;
    private String value;

    public ExcelAdapter(JTable table, ClientModel model, Adaptable serverInterface, StringCellParser[] parsers) {
        this.table = table;
        this.model = model;
        this.editor = (CellEditor)serverInterface.getAdapter(CellEditor.class);
        this.parsers = parsers;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        table.registerKeyboardAction(this, "Copy", copy, 0);
        table.registerKeyboardAction(this, "Paste", paste, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int j;
        Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (e.getActionCommand().compareTo("Copy") == 0) {
            int numcols = this.table.getSelectedColumnCount();
            int numrows = this.table.getSelectedRowCount();
            if (numcols == 0 || numrows == 0) {
                return;
            }
            int[] rowsselected = this.table.getSelectedRows();
            int[] colsselected = this.table.getSelectedColumns();
            if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                return;
            }
            Object[] rows = new Object[numrows];
            int i = 0;
            while (i < numrows) {
                Object[] cols;
                rows[i] = cols = new Object[numcols];
                int j2 = 0;
                while (j2 < numcols) {
                    cols[j2] = SpreadsheetUtils.getLabel((ClientModel)this.model, (int)rowsselected[i], (int)colsselected[j2]);
                    ++j2;
                }
                ++i;
            }
            StringBuilder builder = new StringBuilder();
            int i2 = 0;
            while (i2 < rows.length) {
                Object[] cols = (Object[])rows[i2];
                j = 0;
                while (j < cols.length) {
                    Object value;
                    if (j > 0) {
                        builder.append("\t");
                    }
                    if ((value = cols[j]) != null) {
                        builder.append(value.toString());
                    }
                    ++j;
                }
                builder.append("\n");
                ++i2;
            }
            this.clipboard = new Range(rowsselected[0], rowsselected[0] + numrows - 1, colsselected[0], colsselected[0] + numcols - 1);
            this.clipboardOwner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard arg0, Transferable arg1) {
                    if (ExcelAdapter.this.clipboardOwner == this) {
                        ExcelAdapter.this.clipboardOwner = null;
                        ExcelAdapter.this.clipboard = null;
                    }
                }
            };
            system.setContents(new StringSelection(builder.toString()), this.clipboardOwner);
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            int[] selectedRows = this.table.getSelectedRows();
            int[] selectedColumns = this.table.getSelectedColumns();
            if (selectedRows.length == 0 || selectedColumns.length == 0) {
                return;
            }
            int startRow = selectedRows[0];
            int startCol = selectedColumns[0];
            if (this.clipboardOwner == null) {
                if (this.editor == null) {
                    return;
                }
                String trstring = null;
                try {
                    trstring = (String)system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (trstring == null || trstring.isEmpty()) {
                    return;
                }
                ITask task = ThreadLogger.getInstance().begin("Spreadsheet.paste");
                ArrayList<String> removals = new ArrayList<String>();
                String[] rows = newline.split(trstring);
                int i = 0;
                while (i < rows.length) {
                    String[] cols = tab.split(rows[i]);
                    int j3 = 0;
                    while (j3 < cols.length) {
                        this.value = cols[j3];
                        if (this.value.length() > 0 && startRow + i < this.table.getRowCount() && startCol + j3 < this.table.getColumnCount()) {
                            CellValue cell = (CellValue)this.table.getValueAt(startRow + i, startCol + j3);
                            if (cell.label != null) {
                                String location = Spreadsheets.cellName((int)(startRow + i), (int)(startCol + j3));
                                Boolean computed = (Boolean)this.model.getPropertyAt(location, "Computed");
                                if (computed != null && computed.booleanValue()) {
                                    return;
                                }
                                removals.add(location);
                            }
                        }
                        ++j3;
                    }
                    ++i;
                }
                Transaction tr = this.editor.startTransaction(OperationMode.OPERATION);
                int i3 = 0;
                while (i3 < rows.length) {
                    String[] cols = tab.split(rows[i3]);
                    int j4 = 0;
                    while (j4 < cols.length) {
                        this.value = cols[j4];
                        if (this.value.length() > 0 && startRow + i3 < this.table.getRowCount() && startCol + j4 < this.table.getColumnCount()) {
                            String property = this.value.startsWith("=") ? "content#expression" : "content";
                            this.editor.edit(tr, Spreadsheets.cellName((int)(startRow + i3), (int)(startCol + j4)), property, Variant.ofInstance((Object)this.value), null);
                        }
                        ++j4;
                    }
                    ++i3;
                }
                tr.commit();
                task.finish();
            } else {
                Range from = (Range)this.clipboard;
                Range to = new Range(startRow, startRow + from.height() - 1, startCol, startCol + from.width() - 1);
                Transaction tr = this.editor.startTransaction(OperationMode.OPERATION);
                int i = 0;
                while (i < from.height()) {
                    j = 0;
                    while (j < from.width()) {
                        String fromCell = Spreadsheets.cellName((int)(from.startRow + i), (int)(from.startColumn + j));
                        String toCell = Spreadsheets.cellName((int)(to.startRow + i), (int)(to.startColumn + j));
                        Object obj = this.model.getPropertyAt(fromCell, "content");
                        if (obj != null) {
                            MutableVariant variant = SpreadsheetUtils.createVariant();
                            System.out.println("asdasd fromCell toCell " + fromCell + " " + toCell);
                            this.editor.copy(tr, fromCell, variant, null);
                            this.editor.edit(tr, toCell, "content", (Variant)variant, null);
                        }
                        ++j;
                    }
                    ++i;
                }
                tr.commit();
            }
        }
    }
}

