/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import gnu.trove.map.hash.THashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.ui.Spreadsheet;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public class ClientModelImpl
implements ClientModel {
    private final Map<String, Map<String, Object>> properties = new THashMap();
    private final Map<String, Map<String, Object>> cells = new THashMap();
    private int maxRow = 0;
    private int maxColumn = 0;
    private Set<String> clears = new HashSet<String>();
    private ArrayList<String> modLocation = new ArrayList();
    private ArrayList<String> modProperty = new ArrayList();
    private ArrayList<Object> modValue = new ArrayList();
    private Map<Long, Rectangle> spanMap = new HashMap<Long, Rectangle>();
    CopyOnWriteArrayList<ClientModel.ClientModelListener> listeners = new CopyOnWriteArrayList();
    private final Set<String> sizing = CollectionUtils.toSet((Object[])new String[]{"columnCount", "rowCount", "fitColumns", "fitRows"});

    public ClientModelImpl() {
        if (Spreadsheet.DEBUG) {
            System.out.println("SimpleContainerTableModel.init");
        }
        THashMap sheetDimensions = new THashMap();
        THashMap headers = new THashMap();
        THashMap excel = new THashMap();
        THashMap sources = new THashMap();
        THashMap sheets = new THashMap();
        THashMap context = new THashMap();
        THashMap mode = new THashMap();
        THashMap states = new THashMap();
        sheetDimensions.put("fitRows", false);
        sheetDimensions.put("fitColumns", false);
        sheetDimensions.put("columnCount", 0);
        sheetDimensions.put("rowCount", 0);
        excel.put("Visible", false);
        headers.put("columnWidths", new int[0]);
        headers.put("rowHeights", new int[0]);
        headers.put("columnLabels", new String[0]);
        headers.put("rowLabels", new String[0]);
        sources.put("available", new String[0]);
        sources.put("current", "");
        this.properties.put("Dimensions", (Map<String, Object>)sheetDimensions);
        this.properties.put("Headers", (Map<String, Object>)headers);
        this.properties.put("Excel", (Map<String, Object>)excel);
        this.properties.put("Sources", (Map<String, Object>)sources);
        this.properties.put("Sheets", (Map<String, Object>)sheets);
        this.properties.put("Context", (Map<String, Object>)context);
        this.properties.put("Mode", (Map<String, Object>)mode);
        this.properties.put("States", (Map<String, Object>)states);
        this.setProperty("Excel", "Visible", false);
    }

    public void addListener(ClientModel.ClientModelListener listener) {
        this.listeners.add(listener);
        listener.rows(this.getRows());
        listener.columns(this.getColumns());
        listener.rowLabels((String[])this.getPropertyAt("Headers", "rowLabels"));
        listener.columnWidths((int[])this.getPropertyAt("Headers", "columnWidths"));
        listener.sources((String[])this.getPropertyAt("Sources", "available"), (String)this.getPropertyAt("Sources", "current"));
    }

    public void removeListener(ClientModel.ClientModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireFlush() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.flush();
        }
    }

    private void fireRows() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.rows(this.getRows());
        }
    }

    private void fireColumns() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.columns(this.getColumns());
        }
    }

    private void fireColumnWidths() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.columnWidths((int[])this.getPropertyAt("Headers", "columnWidths"));
        }
    }

    private void fireSources() {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.sources((String[])this.getPropertyAt("Sources", "available"), (String)this.getPropertyAt("Sources", "current"));
        }
    }

    private void fireProperty(String location, String property, Object value) {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.propertyChange(location, property, value);
        }
    }

    private void fireCleared(String location) {
        for (ClientModel.ClientModelListener listener : this.listeners) {
            listener.cleared(location);
        }
    }

    public <T> T getPossiblePropertyAt(String location, String property) {
        try {
            T t = this.getPropertyAt(location, property);
            return t;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public synchronized <T> T getPropertyAt(String location, String property) {
        Map<String, Object> props;
        if (Spreadsheet.DEBUG) {
            System.out.println("SimpleContainerTableModel.getPropertyAt " + location + " " + property);
        }
        if ((props = this.properties.get(location)) != null) {
            return (T)props.get(property);
        }
        Map<String, Object> cls = this.cells.get(location);
        if (cls != null) {
            return (T)cls.get(property);
        }
        return null;
    }

    private boolean sizingProperty(String property) {
        return this.sizing.contains(property);
    }

    private boolean checkMaxRow(int row) {
        if (row + 1 > this.maxRow) {
            this.maxRow = row + 1;
            return true;
        }
        return false;
    }

    private boolean checkMaxColumn(int column) {
        if (column + 1 > this.maxColumn) {
            this.maxColumn = column + 1;
            return true;
        }
        return false;
    }

    public synchronized void setProperty(String location, String property, Object value) {
        assert (location != null);
        assert (property != null);
        this.modLocation.add(location);
        this.modProperty.add(property);
        this.modValue.add(value);
    }

    public void clearAll() {
        this.clears.addAll(this.cells.keySet());
    }

    public synchronized void clear(String location) {
        if (location.startsWith("Style")) {
            return;
        }
        this.clears.add(location);
    }

    public synchronized void flush() {
        for (String location : this.clears) {
            Map<String, Object> cls = this.cells.remove(location);
            if (cls == null) {
                return;
            }
            long l = Spreadsheets.decodeCellCoded((String)location);
            int row = (int)(l & 0xFFFFFFFFFFFFFFFFL) - 1;
            int column = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
            if (this.checkMaxRow(row)) {
                this.fireRows();
            }
            if (this.checkMaxColumn(column)) {
                this.fireColumns();
            }
            this.removeSpan(row, column);
            this.fireCleared(location);
        }
        int i = 0;
        while (i < this.modLocation.size()) {
            Map<String, Object> props;
            String location = this.modLocation.get(i);
            String property = this.modProperty.get(i);
            Object value = this.modValue.get(i);
            if (Spreadsheet.DEBUG) {
                System.out.println("ClientModelImpl.setProperty " + location + " " + property + " " + String.valueOf(value));
            }
            if ((props = this.properties.get(location)) != null || location.startsWith("Style")) {
                if (location.startsWith("Style") && props == null) {
                    props = new HashMap<String, Object>();
                    this.properties.put(location, props);
                }
                if (this.sizingProperty(property)) {
                    int currentRows = this.getRows();
                    int currentCols = this.getColumns();
                    props.put(property, value);
                    if (this.getRows() != currentRows) {
                        this.fireRows();
                    }
                    if (this.getColumns() != currentCols) {
                        this.fireColumns();
                    }
                } else {
                    props.put(property, value);
                    if (property.equals("columnWidths")) {
                        this.fireColumnWidths();
                    }
                    if (property.equals("available") || property.equals("current")) {
                        this.fireSources();
                    }
                }
            } else {
                Map<String, Object> cls = this.cells.get(location);
                if (cls == null) {
                    cls = new HashMap<String, Object>();
                    this.cells.put(location, cls);
                }
                cls.put(property, value);
                long l = Spreadsheets.decodeCellCoded((String)location);
                int row = (int)(l & 0xFFFFFFFFFFFFFFFFL) - 1;
                int column = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
                if (this.checkMaxRow(row)) {
                    this.fireRows();
                }
                if (this.checkMaxColumn(column)) {
                    this.fireColumns();
                }
                boolean rowSpanProperty = property.equals("rowSpan");
                boolean columnSpanProperty = property.equals("columnSpan");
                if (rowSpanProperty || columnSpanProperty) {
                    Rectangle span = this.getRootSpan(row, column);
                    int size = (Integer)value;
                    if (span == null) {
                        if (size > 1) {
                            span = rowSpanProperty ? this.createSpan(row, column, size, 1) : this.createSpan(row, column, 1, size);
                        }
                    } else {
                        if (rowSpanProperty) {
                            span.height = size;
                        } else {
                            span.width = size;
                        }
                        if (span.width == 1 && span.height == 1) {
                            this.removeSpan(row, column);
                        }
                    }
                }
            }
            this.fireProperty(location, property, value);
            ++i;
        }
        this.clears.clear();
        this.modLocation.clear();
        this.modProperty.clear();
        this.modValue.clear();
        this.fireFlush();
    }

    public int getRows() {
        boolean fitRows = (Boolean)this.getPropertyAt("Dimensions", "fitRows");
        if (fitRows) {
            return this.maxRow;
        }
        return (Integer)this.getPropertyAt("Dimensions", "rowCount");
    }

    public int getColumns() {
        boolean fitCols = (Boolean)this.getPropertyAt("Dimensions", "fitColumns");
        if (fitCols) {
            return this.maxColumn;
        }
        return (Integer)this.getPropertyAt("Dimensions", "columnCount");
    }

    public int[] getColumnWidths() {
        int[] data = (int[])this.getPropertyAt("Headers", "columnWidths");
        return (int[])data.clone();
    }

    public int[] getRowHeights() {
        int[] data = (int[])this.getPropertyAt("Headers", "rowHeights");
        return (int[])data.clone();
    }

    public synchronized Collection<Pair<String, Object>> listAll(String property) {
        Object value;
        ArrayList<Pair<String, Object>> result = new ArrayList<Pair<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : this.properties.entrySet()) {
            value = entry.getValue().get(property);
            if (value == null) continue;
            result.add((Pair<String, Object>)Pair.make((Object)entry.getKey(), (Object)value));
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.cells.entrySet()) {
            value = entry.getValue().get(property);
            if (value == null) continue;
            result.add((Pair<String, Object>)Pair.make((Object)entry.getKey(), (Object)value));
        }
        return result;
    }

    private long spanKey(int row, int column) {
        return (long)(row & 0xFFFFFFFF) | (long)(column & 0xFFFFFFFF) << 32;
    }

    public synchronized Rectangle getSpan(int row, int column) {
        for (Rectangle span : this.spanMap.values()) {
            if (!span.contains(column, row)) continue;
            return new Rectangle(span);
        }
        return null;
    }

    public synchronized List<Rectangle> getSpans() {
        ArrayList<Rectangle> spans = new ArrayList<Rectangle>(this.spanMap.size());
        for (Rectangle span : this.spanMap.values()) {
            spans.add(new Rectangle(span));
        }
        return spans;
    }

    private Rectangle getRootSpan(int row, int column) {
        return this.spanMap.get(this.spanKey(row, column));
    }

    private Rectangle createSpan(int row, int column, int rowSpan, int columnSpan) {
        Rectangle span = new Rectangle(column, row, columnSpan, rowSpan);
        this.spanMap.put(this.spanKey(row, column), span);
        return span;
    }

    private void removeSpan(int row, int column) {
        this.spanMap.remove(this.spanKey(row, column));
    }
}

