package org.simantics.spreadsheet.synchronization;

import java.util.Collection;
import java.util.Map;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.solver.SheetLineComponent;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.base.ModuleUpdateContext;
import org.simantics.structural.synchronization.base.ModuleUpdaterBase;
import org.simantics.structural.synchronization.base.PropertyUpdateRule;

public class LineNodeUpdater extends ModuleUpdaterBase<SheetLineComponent> {

    public LineNodeUpdater(String id) {

        super(id);

        isComposite = true;

        addPropertyUpdateRule(new PropertyUpdateRule<SheetLineComponent>() {

            @Override
            public String getPropertyName() {
                return "keys";
            }

            @Override
            public void apply(ModuleUpdateContext<SheetLineComponent> context, boolean isCreating,
                    Map<String, Variant> propertyMap, Map<String, Collection<String>> connectionMap, Variant value) {

                LinesCommandBuilder builder = context.<LinesCommandBuilder>getConcreteCommand();
                Variant v = propertyMap.get("keys");
                if (v != null & v.getValue() != null)
                    builder.keys = (int[])v.getValue();

            }

        });

    }

    @Override
    public CommandBuilder createAddCommandBuilder(String name) {
        return new LinesCommandBuilder(name, false);
    }

    @Override
    public CommandBuilder createUpdateCommandBuilder(String name) {
        return new LinesCommandBuilder(name, true);
    }

}