package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;

class SumFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        Double sum = 0.0;
        for (AstValue value : args.values) {
            Object result = value.accept(visitor);

            if (result instanceof SpreadsheetMatrix) {
                Object value2 = ((SpreadsheetMatrix) result).sumWithFormulaError();
                if(value2 instanceof String) return value2; //means sumWithFormulaError returned an Error message.
                sum += ((Number)value2).doubleValue();
            } else if(result instanceof String && !result.equals("")){
                FormulaError2 error = FormulaError2.forString(result.toString());
                if(error!=null) return error.getString();
                Double v = Spreadsheets.asDoubleWhereEmptyStringIsZero(result);
                if(v!=null)
                    sum += v;
            } else if(result instanceof Number){
                sum += ((Number)result).doubleValue();
            } else {
                sum += Spreadsheets.asNumber(result);
            }
        }
        return sum;
    }
}