package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class SqrtFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 1) throw new IllegalStateException();

        Object number = args.values.get(0).accept(visitor);
        Double dVal = Spreadsheets.asDoubleWhereEmptyStringIsZero(number);
        if(dVal==null) return FormulaError2.handleErrorCall(number);
        if(dVal<0) return FormulaError2.NUM.getString();

        return Math.sqrt(dVal);
    }
}
