package org.simantics.spreadsheet.solver.formula;

import java.util.HashMap;
import java.util.Map;

import org.simantics.spreadsheet.solver.SpreadsheetBook;

public class SpreadsheetEvaluationEnvironment {

    final private SpreadsheetBook book;
    private Map<String, CellFormulaFunction<?>> functions = new HashMap<>();
    public int iterationLimit = 100;

    public SpreadsheetEvaluationEnvironment(SpreadsheetBook book) {
        this.book = book;

        functions.put("AND", new AndFormulaFunction());
        functions.put("AVERAGE", new AverageFormulaFunction());

        functions.put("COUNTIF", new CountifFormulaFunction());

        functions.put("GEOMEAN", new GeomeanFormulaFunction());

        functions.put("HLOOKUP", new HlookupFormulaFunction());

        functions.put("IF", new IfFormulaFunction());
        functions.put("IFERROR",new IfErrorFormulaFunction());
        functions.put("ISERROR",new IsErrorFormulaFunction());
        
        functions.put("LINEST", new LinestFormulaFunction());

        functions.put("MATCH", new MatchFormulaFunction());
        functions.put("MAX", new MaxFormulaFunction());
        functions.put("MIN", new MinFormulaFunction());
        
        functions.put("OR", new OrFormulaFunction());
        
        functions.put("PI", new PiFormulaFunction());
        functions.put("POWER", new PowerFormulaFunction());

        functions.put("ROUND", new RoundFormulaFunction());
        functions.put("ROUNDUP", new RoundupFormulaFunction());
        
        functions.put("SQRT", new SqrtFormulaFunction());
        functions.put("SUM", new SumFormulaFunction());
        functions.put("SUMIF", new SumifFormulaFunction());
        
        functions.put("TODAY", new TodayFormulaFunction());

        functions.put("VLOOKUP", new VlookupFormulaFunction());
        
        functions.put("YEAR", new YearFormulaFunction());
        
    }

    public CellFormulaFunction<?> getFunction(String name) {
        return functions.get(name);
    }

    public SpreadsheetBook getBook() {
        return book;
    }

    private static Map<SpreadsheetBook, SpreadsheetEvaluationEnvironment> INSTANCES = new HashMap<>();

    public static SpreadsheetEvaluationEnvironment getInstance(SpreadsheetBook book) {
        SpreadsheetEvaluationEnvironment env = INSTANCES.get(book);
        if (env == null) {
            env = new SpreadsheetEvaluationEnvironment(book);
            INSTANCES.put(book, env);
        }
        return env;
    }

    public static boolean removeInstance(SpreadsheetBook book) {
        return INSTANCES.remove(book) != null;
    }
}
