package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class RoundFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 2) throw new IllegalStateException();

        Object number = args.values.get(0).accept(visitor);
        Object digits = args.values.get(1).accept(visitor);

        FormulaError2 err1 = FormulaError2.forObject(number);
        if(err1!=null) return err1.getString();
        FormulaError2 err2 = FormulaError2.forObject(digits);
        if(err2!=null) return err2.getString();

        double n = Spreadsheets.asNumber(number);
        double n2 = Spreadsheets.asNumber(digits);
        Double scale = Math.pow(10, n2);

        long l = Math.round(scale * n);
        Double d = Double.valueOf(((double) l) / scale);
        return d;
    }
}