package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class PowerFormulaFunction implements CellFormulaFunction<Object> {

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {

        if (args.values.size() != 2)
            throw new IllegalStateException();

        Object number1 = args.values.get(0).accept(visitor);
        Double dVal1 = Spreadsheets.asDoubleWhereEmptyStringIsZero(number1);
        if(dVal1==null) return FormulaError2.handleErrorCall(number1);
        if(dVal1<0) return FormulaError2.NUM.getString();

        Object number2 = args.values.get(1).accept(visitor);
        Double dVal2 = Spreadsheets.asDoubleWhereEmptyStringIsZero(number2);
        if(dVal2==null) return FormulaError2.handleErrorCall(number2);
        if(dVal2<0) return FormulaError2.NUM.getString();

        return Math.pow(dVal1, dVal2);
        
    }
}
