package org.simantics.spreadsheet.solver;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.ExternalRef.ExternalRefListener;

class ExternalRefData implements ExternalRefListener {
    
    final private SpreadsheetBook book;
    final private long referenceKey;
    final private ExternalRef ref;
    private boolean isDisposed = false;
    private Variant value = SpreadsheetBook.DEFAULT_VALUE;
    
    public ExternalRefData(SpreadsheetBook book, long referenceKey, ExternalRef ref) {
        this.book = book;
        this.referenceKey = referenceKey;
        this.ref = ref;
        ref.listen(book.context, this);
    }
    
    public Variant getContent() {
        return value;
    }
    
    public ExternalRef getRef() {
        return ref;
    }

    @Override
    public void newValue(Variant newVariant) {
        SpreadsheetCell cell = book.cellByReferenceKey(referenceKey);
        if(cell.getContent() instanceof SpreadsheetSCLConstant) {
            SpreadsheetSCLConstant ssc = (SpreadsheetSCLConstant)cell.getContent();
            Object content = ssc.getContent();
            if(content.equals(ref)) {
                value = newVariant;
                book.fireChanges(book.invalidate(cell));
                return;
            }
        }
        isDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        if(isDisposed)
            return true;
        return book.isDisposed();
    }
    
}