/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet;

import java.util.function.Consumer;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;

public interface CellEditor<O> {

    /**
     * @deprecated use {@link #edit(Transaction, String, String, Variant, Consumer)} instead
     */
    @Deprecated
    default <T> void edit(Transaction<O> transaction, String location, String property, T value, Binding binding, Consumer<?> callback) {
        edit(transaction, location, property, new Variant(binding, value), callback);
    }

    /**
     * @deprecated use {@link #edit(Transaction, String, String, Variant, Consumer)}
     *             with property ClientModel.CONTENT instead
     */
    @Deprecated 
    default void edit(Transaction<O> transaction, String location, Variant variant, Consumer<?> callback) {
        edit(transaction, location, ClientModel.CONTENT, variant, callback);
    }

    /*
     * Sets the given property of the given cell
     * 
     * @param transaction a combined transaction, <code>null</code> for immediate change
     * @param location a cell location e.g. 'A1'
     * @param property the name of the property
     * @param variant the property value
     * @param callback to execute after editing, may be <code>null</code>
     */
    void edit(Transaction<O> transaction, String location, String property, Variant value, Consumer<?> callback);

    void copy(Transaction<O> transaction, String location, MutableVariant variant, Consumer<?> callback);

    /*
     * Creates a new transaction object
     */
    Transaction<O> startTransaction(OperationMode mode);

}
