/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeManagerVariableBuilder;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.spreadsheet.graph.SpreadsheetNodeManager;
import org.simantics.spreadsheet.graph.SpreadsheetSessionManager;
import org.simantics.spreadsheet.graph.function.SpreadsheetRootVariable;

public class SpreadsheetVariableBuilder
extends NodeManagerVariableBuilder {
    public Variable buildChild(ReadGraph graph, Variable parent, VariableNode node, Resource child) throws DatabaseException {
        if (parent instanceof ProxyChildVariable) {
            String sessionName = parent.getURI(graph);
            return this.createChild(graph, parent, sessionName, child);
        }
        return new StandardGraphChildVariable(parent, node, child);
    }

    protected Variable createChild(ReadGraph graph, Variable parent, String sessionName, Resource child) throws DatabaseException {
        NodeSupport<?> support = this.getNodeSupport(graph, sessionName);
        return new SpreadsheetRootVariable(parent, new VariableNode(support, this.getRoot(graph, support, sessionName)), child);
    }

    protected NodeSupport<?> getNodeSupport(ReadGraph graph, String sessionName) throws DatabaseException {
        return SpreadsheetSessionManager.getInstance().getOrCreateNodeSupport(graph, sessionName);
    }

    protected Object getRoot(ReadGraph graph, NodeSupport<?> support, String sessionName) {
        SpreadsheetNodeManager manager = (SpreadsheetNodeManager)support.manager;
        return manager.getRoot();
    }
}

