package org.simantics.spreadsheet.graph.synchronization;

import org.simantics.db.ReadGraph;
import org.simantics.spreadsheet.graph.SpreadsheetReferenceResolver;
import org.simantics.spreadsheet.solver.SheetLineComponent;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.structural.synchronization.base.SynchronizationEventHandlerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetSynchronizationEventHandler extends SynchronizationEventHandlerBase<SheetLineComponent> {

	public SpreadsheetSynchronizationEventHandler(ReadGraph graph, SpreadsheetBook book) {
		super(book, new SpreadsheetReferenceResolver(book), book, book, book, book.getMapping());
	}

    @Override
    public Logger getLogger() {
        return LoggerFactory.getLogger(getClass());
    }

}
