package org.simantics.spreadsheet.fileimport;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.fileimport.SimanticsResourceFileImport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.db.SCLFunctions;
import org.simantics.spreadsheet.graph.ExcelImport;

public class ExcelFileImport extends SimanticsResourceFileImport {

    private static final Map<String, String> ALLOWED_EXTENSIONS = new HashMap<>(2);
    
    static {
        ALLOWED_EXTENSIONS.put("*.xls", "Excel file");
        ALLOWED_EXTENSIONS.put("*.xlsx", "Excel file");
        ALLOWED_EXTENSIONS.put("*.xlsm", "Excel file");
    }
    
    @Override
    public Optional<Resource> perform(Resource possibleSelection, Path file) throws Exception {
        if(possibleSelection != null) {
            Layer0 L0 = Layer0.getInstance(Simantics.getSession());
            Resource library = SCLFunctions.evaluateDB("Simantics/SharedOntologies", "createSharedOntology", "http://" + file.toFile().getName() + "@A", L0.SharedOntology);
            return Optional.ofNullable(ExcelImport.importBookR(library, file.toFile()));
        } else {
            throw new NullPointerException("No selection provided - Cannot import book");
        }
    }

    @Override
    public Map<String, String> allowedExtensionsWithFilters() {
        return ALLOWED_EXTENSIONS;
    }

    @Override
    public Resource defaultParentResource() {
        return null;
    }

}
