/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.common;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.FontData;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.ITreeTableCell;
import org.simantics.document.server.io.SimpleFont;
import org.simantics.spreadsheet.common.TableCell;

public class TreeTableCell
extends TableCell
implements ITreeTableCell {
    private int parent = -1;
    private Object parentData;
    private boolean editable = true;
    private Object data;

    public TreeTableCell() {
    }

    public TreeTableCell(String text, Object data, Object font, Object parentData, int parent, int row, int column, boolean editable) {
        super(column, row, 0, 0, text, (IFont)font, null, null, false, 1, 1);
        this.editable = editable;
        this.parent = parent;
        this.parentData = parentData;
        this.data = data;
    }

    @Override
    public int getRowSpan() {
        throw new IllegalStateException("Row span is not supported in TreeTableCell");
    }

    @Override
    public int getColumnSpan() {
        throw new IllegalStateException("Column span is not supported in TreeTableCell");
    }

    public static TreeTableCell createTreeTableCell(String text, Object data, Object font, int parent, int row, int column, boolean editable) {
        return new TreeTableCell(text, data, TreeTableCell.extractIFont(font), null, parent, row, column, editable);
    }

    public static TreeTableCell createTreeTableCell2(String text, Object data, Object font, Object parentData, int row, int column, boolean editable) {
        return new TreeTableCell(text, data, TreeTableCell.extractIFont(font), parentData, -1, row, column, editable);
    }

    private static IFont extractIFont(Object font) {
        if (font instanceof FontDescriptor) {
            FontDescriptor descriptor = (FontDescriptor)font;
            String family = "";
            Object style = "";
            int size = 12;
            FontData[] fontDataArray = descriptor.getFontData();
            int n = fontDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontData d = fontDataArray[n2];
                family = d.getName();
                if ((d.getStyle() & 2) != 0) {
                    style = (String)style + "Italic";
                }
                if ((d.getStyle() & 1) != 0) {
                    style = (String)style + "Bold";
                }
                size = d.getHeight();
                ++n2;
            }
            return new SimpleFont(family, (String)style, size);
        }
        return null;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public Object getParentData() {
        return this.parentData;
    }

    public int getParent() {
        return this.parent;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.data != null ? 31 * result + this.data.hashCode() : this.parent;
        result = this.parentData != null ? 31 * result + this.parentData.hashCode() : result;
        result = 31 * result + Integer.hashCode(this.parent);
        result = 31 * result + Boolean.hashCode(this.editable);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeTableCell other = (TreeTableCell)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.parentData == null ? other.parentData != null : !this.parentData.equals(other.parentData)) {
            return false;
        }
        if (this.parent != other.parent) {
            return false;
        }
        if (this.editable != other.editable) {
            return false;
        }
        return super.equals(obj);
    }
}

