/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.common.matrix;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;

import org.simantics.spreadsheet.Matrix;

public class MatrixImpl implements Matrix, Externalizable {

	private int rows;
	private int columns;
	private Object[] data;
	
	public MatrixImpl() {
		
	}
	
	public MatrixImpl(int rows, int columns) {
		this.rows = rows;
		this.columns = columns;
		this.data = new Object[rows*columns];
	}

	@Override
	public int getColumnCount() {
		return columns;
	}

	@Override
	public int getRowCount() {
		return rows;
	}

	@Override
	public void readExternal(ObjectInput in) throws IOException,
			ClassNotFoundException {
		rows = in.readInt();
		columns = in.readInt();
		data = new Object[rows*columns];
		for(int i=0;i<data.length;i++) data[i] = in.readObject();
	}

	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(rows);
		out.writeInt(columns);
		for(Object o : data) out.writeObject(o);
	}

	@Override
	public Object get(int row, int column) {
		return data[column*rows + row];
	}
	
	public void setColumn(int column, Collection<Object> objects) {
		int index = rows*column;
		for(Object o : objects) {
			data[index++] = o;
		}
	}

	public void set(int row, int column, Object object) {
		data[rows*column + row] = object;
	}

	public Collection<Object> getColumn(int column) {
		ArrayList<Object> result = new ArrayList<Object>();
		for(int i=0;i<rows;i++) {
			result.add(data[rows*column+i]);
		}
		return result;
	}

	public Collection<Object> getRow(int row) {
		ArrayList<Object> result = new ArrayList<Object>();
		for(int i=0;i<columns;i++) {
			result.add(data[row + columns*i]);
		}
		return result;
	}
	
}
