package org.simantics.spreadsheet.common;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;


public class Activator implements BundleActivator {

	/**
	 * Name of the log file. 
	 */
	public static String LOG_FILE_NAME = "spreadsheet.log";

	// The plug-in ID
	public static final String BUNDLE_ID = "org.simantics.spreadsheet.common"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;

	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(BundleContext context) throws Exception {
		plugin = this;

		String prop = System.getProperty("osgi.instance.area", null);
		if (prop != null) {
			try {
				URL url = new URL(prop);
				if ("file".equals(url .getProtocol())) {
					try {
						File path = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
						if (!path.exists())
							path.mkdirs();
						if (path.exists() && path.canWrite()) {
							File logFile = new File(path, LOG_FILE_NAME);
							if (!logFile.exists() || (logFile.isFile() && logFile.canWrite()))
								LOG_FILE_NAME = logFile.getAbsolutePath();

						}
					} catch (UnsupportedEncodingException e) {
						// Should never happen since UTF-8 is always supported.
					}
				}
			} catch (MalformedURLException e) {
				// Ignore.
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(BundleContext context) throws Exception {
		plugin = null;
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

}