package org.simantics.layer0;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class SoftwareConfigurationResources {
    
    public final Resource HasVersion;
    public final Resource HasVersion_Inverse;
    public final Resource IsCompatibleWith;
    public final Resource Product;
    public final Resource Update;
    public final Resource Update_From;
    public final Resource Update_HasMigrationAction;
    public final Resource Update_To;
    public final Resource Version;
    public final Resource Version_HasUpdate;
    public final Resource Version_Of;
        
    public static class URIs {
        public static final String HasVersion = "http://www.simantics.org/SoftwareConfiguration-1.1/HasVersion";
        public static final String HasVersion_Inverse = "http://www.simantics.org/SoftwareConfiguration-1.1/HasVersion/Inverse";
        public static final String IsCompatibleWith = "http://www.simantics.org/SoftwareConfiguration-1.1/IsCompatibleWith";
        public static final String Product = "http://www.simantics.org/SoftwareConfiguration-1.1/Product";
        public static final String Update = "http://www.simantics.org/SoftwareConfiguration-1.1/Update";
        public static final String Update_From = "http://www.simantics.org/SoftwareConfiguration-1.1/Update/From";
        public static final String Update_HasMigrationAction = "http://www.simantics.org/SoftwareConfiguration-1.1/Update/HasMigrationAction";
        public static final String Update_To = "http://www.simantics.org/SoftwareConfiguration-1.1/Update/To";
        public static final String Version = "http://www.simantics.org/SoftwareConfiguration-1.1/Version";
        public static final String Version_HasUpdate = "http://www.simantics.org/SoftwareConfiguration-1.1/Version/HasUpdate";
        public static final String Version_Of = "http://www.simantics.org/SoftwareConfiguration-1.1/Version/Of";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public SoftwareConfigurationResources(ReadGraph graph) {
        HasVersion = getResourceOrNull(graph, URIs.HasVersion);
        HasVersion_Inverse = getResourceOrNull(graph, URIs.HasVersion_Inverse);
        IsCompatibleWith = getResourceOrNull(graph, URIs.IsCompatibleWith);
        Product = getResourceOrNull(graph, URIs.Product);
        Update = getResourceOrNull(graph, URIs.Update);
        Update_From = getResourceOrNull(graph, URIs.Update_From);
        Update_HasMigrationAction = getResourceOrNull(graph, URIs.Update_HasMigrationAction);
        Update_To = getResourceOrNull(graph, URIs.Update_To);
        Version = getResourceOrNull(graph, URIs.Version);
        Version_HasUpdate = getResourceOrNull(graph, URIs.Version_HasUpdate);
        Version_Of = getResourceOrNull(graph, URIs.Version_Of);
    }
    
    public static SoftwareConfigurationResources getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        SoftwareConfigurationResources ret = session.peekService(SoftwareConfigurationResources.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new SoftwareConfigurationResources(qc.getIndependentGraph(graph));
            session.registerService(SoftwareConfigurationResources.class, ret);
        }
        return ret;
    }
    
    public static SoftwareConfigurationResources getInstance(RequestProcessor session) throws DatabaseException {
        SoftwareConfigurationResources ret = session.peekService(SoftwareConfigurationResources.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<SoftwareConfigurationResources>() {
                public SoftwareConfigurationResources perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new SoftwareConfigurationResources(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(SoftwareConfigurationResources.class, ret);
        }
        return ret;
    }
    
}

