/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.variable;

import java.util.List;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public class DebugNodeManager<Node>
implements NodeManager<Node> {
    protected NodeManager<Node> delegate;

    public DebugNodeManager(NodeManager<Node> delegate) {
        this.delegate = delegate;
    }

    protected long println(String msg) {
        long ts = System.nanoTime();
        double time = (double)ts * 1.0E-6;
        System.out.format("[%s @%f] %s\n", this.delegate.getClass().getSimpleName(), time, msg);
        return ts;
    }

    protected long println(long previousTime, String msg) {
        long ts = System.nanoTime();
        long dt = ts - previousTime;
        double time = (double)ts * 1.0E-6;
        double dtime = (double)dt * 1.0E-6;
        System.out.format("[%s @%f, took %f ms] %s\n", this.delegate.getClass().getSimpleName(), time, dtime, msg);
        return ts;
    }

    protected void format(String msg, Object ... args) {
        this.println(String.format(msg, args));
    }

    @Override
    public Realm getRealm() {
        this.println("getRealm");
        return this.delegate.getRealm();
    }

    @Override
    public String getName(Node node) {
        long ts = this.println("enter getName(" + String.valueOf(node) + ")");
        String name = this.delegate.getName(node);
        this.println(ts, "return getName(" + String.valueOf(node) + ") = " + name);
        return name;
    }

    @Override
    public void addNodeListener(Node node, Runnable listener) {
        long ts = this.println("enter addNodeListener(" + String.valueOf(node) + ", " + String.valueOf(listener) + ")");
        this.delegate.addNodeListener(node, listener);
        this.println(ts, "exit addNodeListener(" + String.valueOf(node) + ", " + String.valueOf(listener) + ")");
    }

    @Override
    public void removeNodeListener(Node node, Runnable listener) {
        long ts = this.println("enter removeNodeListener(" + String.valueOf(node) + ", " + String.valueOf(listener) + ")");
        this.delegate.removeNodeListener(node, listener);
        this.println(ts, "exit removeNodeListener(" + String.valueOf(node) + ", " + String.valueOf(listener) + ")");
    }

    @Override
    public Node getNode(String path) throws NodeManagerException {
        long ts = this.println("enter getNode(" + path + ")");
        Node node = this.getNode(path);
        this.println(ts, "return getNode(" + path + ") = " + String.valueOf(node));
        return node;
    }

    @Override
    public Node getChild(Node node, String name) throws NodeManagerException {
        long ts = this.println("enter getChild(" + String.valueOf(node) + ", " + name + ")");
        Node child = this.getChild(node, name);
        this.println(ts, "return getChild(" + String.valueOf(node) + ", " + name + ") = " + String.valueOf(child));
        return child;
    }

    @Override
    public Node getProperty(Node node, String name) throws NodeManagerException {
        long ts = this.println("enter getProperty(" + String.valueOf(node) + ", " + name + ")");
        Node property = this.delegate.getProperty(node, name);
        this.println(ts, "return getProperty(" + String.valueOf(node) + ", " + name + ") = " + String.valueOf(property));
        return property;
    }

    @Override
    public List<String> getChildNames(Node node) throws NodeManagerException {
        long ts = this.println("enter getChildNames(" + String.valueOf(node) + ")");
        List<String> childNames = this.delegate.getChildNames(node);
        this.println(ts, "return getChildNames(" + String.valueOf(node) + ") = " + String.valueOf(childNames));
        return childNames;
    }

    @Override
    public List<String> getPropertyNames(Node node) throws NodeManagerException {
        long ts = this.println("enter getPropertyNames(" + String.valueOf(node) + ")");
        List<String> propertyNames = this.delegate.getPropertyNames(node);
        this.println(ts, "return getPropertyNames(" + String.valueOf(node) + ") = " + String.valueOf(propertyNames));
        return propertyNames;
    }

    @Override
    public List<Node> getChildren(Node node) throws NodeManagerException {
        long ts = this.println("enter getChildren(" + String.valueOf(node) + ")");
        List<Node> children = this.delegate.getChildren(node);
        this.println(ts, "return getChildren(" + String.valueOf(node) + ") = " + String.valueOf(children));
        return children;
    }

    @Override
    public List<Node> getProperties(Node node) throws NodeManagerException {
        long ts = this.println("enter getProperties(" + String.valueOf(node) + ")");
        List<Node> properties = this.delegate.getProperties(node);
        this.println(ts, "return getProperties(" + String.valueOf(node) + ") = " + String.valueOf(properties));
        return properties;
    }

    @Override
    public Datatype getDatatype(Node node) throws NodeManagerException {
        long ts = this.println("enter getValue(" + String.valueOf(node) + ")");
        Datatype datatype = this.delegate.getDatatype(node);
        this.println(ts, "return getValue(" + String.valueOf(node) + ") = " + String.valueOf(datatype));
        return datatype;
    }

    @Override
    public Object getValue(Node node, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter getValue(" + String.valueOf(node) + ", " + String.valueOf(binding) + ")");
        Object value = this.delegate.getValue(node, binding);
        this.println(ts, "return getValue(" + String.valueOf(node) + ", " + String.valueOf(binding) + ") = " + String.valueOf(value));
        return value;
    }

    @Override
    public Variant getValue(Node node) throws NodeManagerException {
        long ts = this.println("enter getValue(" + String.valueOf(node) + ")");
        Variant value = this.delegate.getValue(node);
        this.println(ts, "return getValue(" + String.valueOf(node) + ") = " + String.valueOf(value));
        return value;
    }

    @Override
    public Object getValue(Node node, String property, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter getValue(" + String.valueOf(node) + ", " + property + ", " + String.valueOf(binding) + ")");
        Object value = this.delegate.getValue(node, property, binding);
        this.println(ts, "return getValue(" + String.valueOf(node) + ", " + property + ", " + String.valueOf(binding) + ") = " + String.valueOf(value));
        return value;
    }

    @Override
    public Variant getValue(Node node, String property) throws NodeManagerException {
        long ts = this.println("enter getValue(" + String.valueOf(node) + ", " + property + ")");
        Variant value = this.delegate.getValue(node, property);
        this.println(ts, "return getValue(" + String.valueOf(node) + ", " + property + ") = " + String.valueOf(value));
        return value;
    }

    @Override
    public void setValue(Node node, Object value, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter setValue(" + String.valueOf(node) + ", " + String.valueOf(value) + ", " + String.valueOf(binding) + ")");
        this.delegate.setValue(node, value, binding);
        this.println(ts, "exit setValue(" + String.valueOf(node) + ", " + String.valueOf(value) + ", " + String.valueOf(binding) + ")");
    }

    @Override
    public void setValue(Node node, String property, Object value, Binding binding) throws NodeManagerException, BindingException {
        long ts = this.println("enter setValue(" + String.valueOf(node) + ", " + property + ", " + String.valueOf(value) + ", " + String.valueOf(binding) + ")");
        this.delegate.setValue(node, property, value, binding);
        this.println(ts, "exit setValue(" + String.valueOf(node) + ", " + property + ", " + String.valueOf(value) + ", " + String.valueOf(binding) + ")");
    }

    @Override
    public String getPropertyURI(Node parent, Node property) {
        long ts = this.println("enter getPropertyURI(" + String.valueOf(parent) + ", " + String.valueOf(property) + ")");
        String result = this.delegate.getPropertyURI(parent, property);
        this.println(ts, "return getPropertyURI(" + String.valueOf(parent) + ", " + String.valueOf(property) + ") = " + result);
        return result;
    }

    @Override
    public Set<String> getClassifications(Node node) throws NodeManagerException {
        long ts = this.println("enter getClassifications(" + String.valueOf(node) + ")");
        Set<String> result = this.delegate.getClassifications(node);
        this.println(ts, "return getClassifications(" + String.valueOf(node) + ") = " + String.valueOf(result));
        return result;
    }
}

