/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.toolkit;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.Realm;
import org.simantics.simulator.variable.exceptions.NoSuchNodeException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.simulator.variable.exceptions.NotInRealmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardNodeManager<Node, Engine extends StandardNodeManagerSupport<Node>>
implements NodeManager<Node> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardNodeManager.class);
    protected final Node root;
    protected final StandardRealm<Node, Engine> realm;
    static final Binding NO_BINDING = new VariantBinding(){

        public Object getContent(Object variant, Binding contentBinding) throws BindingException {
            throw new Error();
        }

        public Object getContent(Object variant) throws BindingException {
            throw new Error();
        }

        public Datatype getContentType(Object variant) throws BindingException {
            throw new Error();
        }

        public Binding getContentBinding(Object variant) throws BindingException {
            throw new Error();
        }

        public Object create(Binding contentBinding, Object content) throws BindingException {
            throw new Error();
        }

        public void setContent(Object variant, Binding contentBinding, Object content) throws BindingException {
            throw new Error();
        }

        public boolean isInstance(Object obj) {
            return true;
        }

        public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
            throw new Error();
        }

        public int compare(Object o1, Object o2) throws RuntimeBindingException {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -System.identityHashCode(o2);
            }
            if (o2 == null) {
                return System.identityHashCode(o1);
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return System.identityHashCode(o1) - System.identityHashCode(o2);
        }
    };
    protected THashMap<Node, Variant> valueCache = new THashMap();
    protected THashMap<Node, THashSet<Runnable>> listeners = new THashMap();
    AtomicBoolean fireNodeListenersScheduled = new AtomicBoolean(false);
    Runnable fireNodeListeners = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StandardNodeManager.this.fireNodeListenersScheduled.set(false);
            TObjectProcedure procedure = r -> {
                r.run();
                return true;
            };
            THashMap tHashMap = StandardNodeManager.this.listeners;
            synchronized (tHashMap) {
                StandardNodeManager.this.listeners.forEachValue(set -> {
                    set.forEach(procedure);
                    return true;
                });
            }
        }
    };
    Runnable clearValueCache = () -> this.valueCache.clear();

    public StandardNodeManager(StandardRealm<Node, Engine> realm, Node root) {
        assert (realm != null);
        assert (root != null);
        this.realm = realm;
        this.root = root;
    }

    public List<String> getChildNames(Node node) throws NodeManagerException {
        List<Node> children = this.getChildren(node);
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (Node child : children) {
            names.add(this.getName(child));
        }
        return names;
    }

    public List<String> getPropertyNames(Node node) throws NodeManagerException {
        List<Node> properties = this.getProperties(node);
        ArrayList<String> names = new ArrayList<String>(properties.size());
        for (Node property : properties) {
            names.add(this.getName(property));
        }
        return names;
    }

    public Object getValue(Node node, String propertyName, Binding binding) throws NodeManagerException, BindingException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        return this.getValue(property, binding);
    }

    public void setValue(Node node, String propertyName, Object value, Binding binding) throws NodeManagerException, BindingException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        this.setValue(property, value, binding);
    }

    public Variant getValue(Node node, String propertyName) throws NodeManagerException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        return this.getValue(property);
    }

    public Object getValue(Node node, Binding binding) throws NodeManagerException, BindingException {
        try {
            Variant value = this.getValue(node);
            if (NodeManager.PENDING_NODE_VALUE == value) {
                return value;
            }
            return value.getValue(binding);
        }
        catch (AdaptException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public String getPropertyURI(Node parent, Node property) {
        return null;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public StandardRealm<Node, Engine> getStandardRealm() {
        return this.realm;
    }

    protected String getRealmId() {
        return this.realm.getId();
    }

    public Node getRoot() {
        return this.root;
    }

    protected boolean isRoot(Node node) {
        return this.root.equals(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeListener(Node node, Runnable listener) {
        THashMap<Node, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get(node);
            if (l == null) {
                l = new THashSet();
                this.listeners.put(node, (Object)l);
            }
            l.add((Object)listener);
        }
        this.getRealm().asyncExec(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeListener(Node node, Runnable listener) {
        THashMap<Node, THashSet<Runnable>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            THashSet l = (THashSet)this.listeners.get(node);
            if (l != null) {
                l.remove((Object)listener);
                if (l.isEmpty()) {
                    this.listeners.remove(node);
                }
            }
        }
    }

    public void fireNodeListeners() {
        if (!this.fireNodeListenersScheduled.getAndSet(true)) {
            this.realm.asyncExec(this.fireNodeListeners);
        }
    }

    public void fireNodeListenersSync() {
        try {
            this.realm.syncExec(this.fireNodeListeners);
        }
        catch (InterruptedException e) {
            LOGGER.error("Synchronous node listener firing was interrupted.", (Throwable)e);
        }
    }

    public void invalidateVariable(Node node) {
        this.refreshVariableImpl(node);
    }

    public void refreshVariable(Node node) {
        this.refreshVariableImpl(node);
    }

    public void refreshVariableImpl(Node node) {
        this.realm.asyncExec(() -> {
            this.valueCache.remove(node);
            THashMap<Node, THashSet<Runnable>> tHashMap = this.listeners;
            synchronized (tHashMap) {
                THashSet runnables = (THashSet)this.listeners.get(node);
                if (runnables != null) {
                    for (Runnable r : runnables) {
                        r.run();
                    }
                }
            }
        });
    }

    public void refreshVariables() {
        this.realm.asyncExec(this.clearValueCache);
        this.fireNodeListeners();
    }

    public void refreshVariablesSync() {
        try {
            this.realm.syncExec(this.clearValueCache);
        }
        catch (InterruptedException e) {
            LOGGER.error("Synchronous value cache refresh was interrupted.", (Throwable)e);
        }
        this.fireNodeListenersSync();
    }

    protected Variant getEngineVariantOrCached(Node node) throws NodeManagerException {
        Variant variant = (Variant)this.valueCache.get(node);
        if (variant == null) {
            Object value = this.realm.getEngine().getEngineValue(node);
            if (NodeManager.PENDING_NODE_VALUE == value) {
                return (Variant)value;
            }
            Binding binding = this.realm.getEngine().getEngineBinding(node);
            variant = new Variant(binding, value);
            this.valueCache.put(node, (Object)variant);
        }
        return variant;
    }

    public Variant getValue(Node node) throws NodeManagerException {
        this.checkThreadAccess();
        return this.getEngineVariantOrCached(node);
    }

    protected void checkThreadAccess() throws NodeManagerException {
        if (Thread.currentThread() != this.realm.getThread()) {
            throw new NotInRealmException();
        }
    }

    protected Datatype getDatatypeForValue(Object value) {
        Binding binding = Bindings.getBindingUnchecked(value.getClass());
        if (binding == null) {
            return null;
        }
        return binding.type();
    }

    public void setValue(Node node, Object value, Binding binding) throws NodeManagerException {
        this.updateValueInner(node, value, binding);
        this.refreshVariable(node);
    }

    public void setValueAndFireSelectedListeners(Node node, Object value, Binding binding, Set<Node> references) throws NodeManagerException {
        this.updateValueInner(node, value, binding);
        this.refreshVariable(node);
        if (references.size() > 0) {
            for (Node n : references) {
                this.invalidateVariable(n);
            }
        }
        this.fireNodeListenersSync();
    }

    private void updateValueInner(Node node, Object value, Binding binding) throws NodeManagerException {
        this.checkThreadAccess();
        Binding targetBinding = this.realm.getEngine().getEngineBinding(node);
        if (binding.equals((Object)targetBinding)) {
            Variant variant = new Variant(binding, value);
            this.valueCache.put(node, (Object)variant);
            this.realm.getEngine().setEngineValue(node, value);
        } else {
            try {
                Adapter adapter = Bindings.getAdapter((Binding)binding, (Binding)targetBinding);
                Object targetValue = adapter.adapt(value);
                Variant variant = new Variant(targetBinding, targetValue);
                this.valueCache.put(node, (Object)variant);
                this.realm.getEngine().setEngineValue(node, targetValue);
            }
            catch (AdapterConstructionException e) {
                throw new NodeManagerException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new NodeManagerException((Throwable)e);
            }
        }
    }

    public String getName(Node node) {
        if (this.isRoot(node)) {
            String id = this.getRealmId();
            int lastSlash = id.lastIndexOf("/");
            if (lastSlash == -1) {
                throw new IllegalStateException("Invalid realm id " + id);
            }
            String name = id.substring(lastSlash + 1);
            return name;
        }
        return this.realm.getEngine().getName(node);
    }

    public Node getNode(String path) throws NodeManagerException {
        this.checkThreadAccess();
        throw new UnsupportedOperationException();
    }

    public Node getChild(Node node, String name) throws NodeManagerException {
        this.checkThreadAccess();
        Map<String, Node> map = this.realm.getEngine().getChildren(node);
        return map.get(name);
    }

    public Node getProperty(Node node, String name) throws NodeManagerException {
        this.checkThreadAccess();
        Map<String, Node> map = this.realm.getEngine().getProperties(node);
        return map.get(name);
    }

    public List<Node> getChildren(Node node) throws NodeManagerException {
        this.checkThreadAccess();
        return new ArrayList<Node>(this.realm.getEngine().getChildren(node).values());
    }

    public List<Node> getProperties(Node node) throws NodeManagerException {
        this.checkThreadAccess();
        return new ArrayList<Node>(this.realm.getEngine().getProperties(node).values());
    }

    public Datatype getDatatype(Node node) throws NodeManagerException {
        Binding b;
        block3: {
            this.checkThreadAccess();
            try {
                Variant v = this.getEngineVariantOrCached(node);
                b = v.getBinding();
                if (b != null) break block3;
                return null;
            }
            catch (RuntimeBindingConstructionException runtimeBindingConstructionException) {
                return null;
            }
        }
        return b.type();
    }

    public void clear() {
        this.valueCache.clear();
        this.listeners.clear();
    }

    public Set<String> getClassifications(Node node) throws NodeManagerException {
        return Collections.emptySet();
    }
}

