/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.simulator;

import org.simantics.databoard.binding.Binding;

public interface IDynamicExperimentLocal extends IExperimentLocal {

    /**
     * Starts or stops simulation depending on the
     * parameter.
     */
    public void simulate(boolean enabled);

    /**
     * Simulates the experiment at lest the given period of time.
     * Giving 0 as parameter simulates the experiment one 'step'.
     * After the duration, the simulation is stopped.
     */
    public void simulateDuration(double duration);

    void setVariableValueById(String id, Object value, Binding binding);
    Object getVariableValueById(String id);

    double getSimulationTime();

}
