/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.datastructures.Pair;

public class CSVItemsQuery
implements Read<List<CSVItem>> {
    String contentUri;

    public CSVItemsQuery(String contentUri) {
        this.contentUri = contentUri;
    }

    public List<CSVItem> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<CSVItem> result = new ArrayList<CSVItem>();
        Resource resource = graph.getResource(this.contentUri);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList subscriptionItems = new ArrayList();
        if (graph.isInstanceOf(resource, MOD.Subscription)) {
            subscriptionItems.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(resource, L0.ConsistsOf, MOD.Subscription_Item)));
        } else {
            for (Resource possibleItem : graph.getObjects(resource, L0.ConsistsOf)) {
                subscriptionItems.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(possibleItem, L0.IsRelatedTo, MOD.Subscription_Item)));
            }
        }
        for (Resource subscriptionItem : subscriptionItems) {
            Binding rviBinding;
            RVI rvi;
            Variable configuration;
            Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(subscriptionItem));
            Resource subscription = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(subscriptionItem, L0.PartOf, MOD.Subscription));
            if (subscription == null || (configuration = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)subscription)) == null) continue;
            CSVItem item = new CSVItem();
            if (model != null) {
                item.modelUri = graph.getURI(model);
            }
            if ((rvi = (RVI)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_VariableId, rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class))) == null) continue;
            item.groupItemId = (String)graph.getPossibleRelatedValue(subscriptionItem, L0.HasName, (Binding)Bindings.STRING);
            if (item.groupItemId == null) continue;
            item.variableReference = rvi.toPossibleString(graph, configuration);
            if (item.variableReference == null) continue;
            item.label = CSVItemsQuery.removeVariablePrefixPath(item.variableReference);
            item.unit = (String)graph.getPossibleRelatedValue(subscriptionItem, MOD.Subscription_Item_Unit, (Binding)Bindings.STRING);
            result.add(item);
        }
        return result;
    }

    static String removeVariablePrefixPath(String rvi) {
        int propIndex = rvi.indexOf(35);
        if (propIndex == -1) {
            return rvi;
        }
        int prevSlash = rvi.lastIndexOf(47, propIndex);
        if (prevSlash == -1) {
            return rvi;
        }
        Pair<String, Integer> attrKey = CSVItemsQuery.attributeKey(rvi, propIndex + 1);
        return rvi.substring(prevSlash + 1, propIndex + 1) + (String)attrKey.first + (String)(attrKey.second != null ? "(" + ((Integer)attrKey.second + 1) + ")" : "");
    }

    static Pair<String, Integer> attributeKey(String key, int start) {
        ChildReference child;
        boolean isIndexed;
        int iy = key.lastIndexOf(47);
        boolean bl = isIndexed = iy >= start;
        if (isIndexed && (child = ChildReference.parsePath((String)key.substring(iy + 1))) instanceof IndexReference) {
            return Pair.make((Object)key.substring(start, iy), (Object)((IndexReference)child).getIndex());
        }
        return Pair.make((Object)key.substring(start), null);
    }

    public static class CSVItem {
        public String modelUri;
        public String label;
        public String groupItemId;
        public String variableReference;
        public String unit;
    }
}

