/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;

public class SaveState {
    @CanExecute
    public boolean canExecute() {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (manager == null) {
            return false;
        }
        IExperiment experiment = manager.getActiveExperiment();
        return experiment != null;
    }

    @Execute
    public void execute() throws ExecutionException {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            SaveStateJob j = new SaveStateJob((IDynamicExperiment)experiment);
            j.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)experiment));
            j.schedule();
        }
    }

    static class SaveStateJob
    extends Job {
        private final IDynamicExperiment experiment;

        public SaveStateJob(IDynamicExperiment experiment) {
            super("Save Experiment State");
            this.experiment = experiment;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", -1);
                this.experiment.saveState();
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.simantics.simulation.ui", "Failed to save state of dynamic experiment " + String.valueOf(this.experiment) + " with ID " + this.experiment.getIdentifier(), t);
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

