/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants2;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.message.ILogger;
import org.simantics.message.MessageService;
import org.simantics.project.IProject;
import org.simantics.simulation.Activator;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.model.ExperimentLoadingCancelled;
import org.simantics.simulation.model.ExperimentLoadingFailed;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.ExperimentManagerListener;
import org.simantics.utils.DataContainer;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ExperimentActivator {
    public static void scheduleActivation(RequestProcessor processor, IProject project, IExperimentManager experimentManager, Resource experiment) {
        ExperimentActivator.scheduleActivation(processor, project, experimentManager, experiment, null);
    }

    public static void scheduleActivation(RequestProcessor processor, IProject project, IExperimentManager experimentManager, Resource experiment, Consumer<IExperiment> callback) {
        Object jobName = "Activate Experiment";
        String experimentName = ExperimentActivator.getName(processor, experiment);
        if (experimentName != null) {
            jobName = (String)jobName + " '" + experimentName + "'";
        }
        ExperimentActivator.scheduleActivation((String)jobName, project, experimentManager, experiment, callback);
    }

    public static void scheduleActivation(String jobName, IProject project, IExperimentManager experimentManager, Resource experiment) {
        ExperimentActivator.scheduleActivation(jobName, project, experimentManager, experiment, null);
    }

    public static void scheduleActivation(String jobName, IProject project, IExperimentManager experimentManager, Resource experiment, Consumer<IExperiment> callback) {
        ExperimentActivationJob job = new ExperimentActivationJob(jobName, project, experimentManager, experiment, callback);
        job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, Boolean.TRUE);
        job.setUser(true);
        job.schedule();
    }

    public static IStatus activate(IProgressMonitor monitor, IProject project, IExperimentManager experimentManager, Resource experiment) {
        return ExperimentActivator.activate(monitor, project, experimentManager, experiment, null);
    }

    public static IStatus activate(IProgressMonitor monitor, IProject project, IExperimentManager experimentManager, Resource experiment, Consumer<IExperiment> callback) {
        return new ExperimentActivator().activateExperiment(monitor, project, experimentManager, experiment, callback);
    }

    private static String getName(RequestProcessor processor, final Resource resource) {
        try {
            return (String)processor.syncRequest((Read)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    try {
                        return (String)graph.adapt(resource, String.class);
                    }
                    catch (AdaptionException adaptionException) {
                        return NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogWarning((Throwable)e);
            return null;
        }
    }

    private IStatus activateExperiment(IProgressMonitor monitor, IProject project, IExperimentManager manager, Resource experimentResource, Consumer<IExperiment> callback) {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Activating experiment", (int)100000);
        ExperimentManagerListener.listenManager(manager);
        final Semaphore activated = new Semaphore(0);
        final DataContainer activatedExperiment = new DataContainer();
        final DataContainer problem = new DataContainer();
        final AtomicInteger worstMessageSeverity = new AtomicInteger(0);
        final ILogger messageService = MessageService.getDefault();
        manager.startExperiment(experimentResource, new IExperimentActivationListener(){

            public void onExperimentActivated(IExperiment experiment) {
                MessageService.defaultLog((IStatus)new Status(1, "org.simantics.simulation.ui", 0, "Activated experiment " + experiment.getIdentifier(), null));
                activatedExperiment.set((Object)experiment);
                activated.release();
            }

            public void onFailure(Throwable e) {
                problem.set((Object)e);
                activated.release();
            }

            public void onMessage(IStatus message) {
                messageService.log(message);
                int s = message.getSeverity();
                if (s > worstMessageSeverity.get()) {
                    worstMessageSeverity.set(s);
                }
            }

            public IProgressMonitor getProgressMonitor() {
                return mon;
            }
        }, true);
        try {
            activated.acquire();
            Throwable t = (Throwable)problem.get();
            IStatus status = null;
            if (t != null) {
                status = Status.error((String)"Experiment activation failed, see Error Log for details.", (Throwable)t);
                if (t instanceof ExperimentLoadingFailed) {
                    ExperimentLoadingFailed ex = (ExperimentLoadingFailed)t;
                    if (t instanceof ExperimentLoadingCancelled) {
                        status = Status.CANCEL_STATUS;
                    } else {
                        Activator.logError((String)"Experiment activation failed, see exception for details.", (Throwable)t);
                        if (PlatformUI.isWorkbenchRunning()) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(this.showError("Experiment Activation Failed", t.getMessage() + "\n\nSee Error Log for details."));
                        }
                    }
                    if (ex.getHelperAction() != null && PlatformUI.isWorkbenchRunning()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(ex.getHelperAction());
                    }
                } else {
                    Activator.logError((String)"Experiment activation failed, see exception for details.", (Throwable)t);
                    if (PlatformUI.isWorkbenchRunning()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(this.showError("Experiment Activation Failed", t.getMessage() + "\n\nSee Error Log for details."));
                    }
                }
            }
            if (callback != null) {
                callback.accept((IExperiment)activatedExperiment.get());
            }
            return status != null ? status : Status.OK_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
    }

    private Runnable showError(final String title, final String message) {
        return new Runnable(){

            @Override
            public void run() {
                Shell parent = WorkbenchUtils.getActiveWorkbenchWindowShell();
                MessageDialog.openError((Shell)parent, (String)title, (String)message);
            }
        };
    }

    static class ExperimentActivationJob
    extends DatabaseJob {
        private IProject project;
        private IExperimentManager experimentManager;
        private Resource experiment;
        private Consumer<IExperiment> callback;

        public ExperimentActivationJob(String name, IProject project, IExperimentManager experimentManager, Resource experiment, Consumer<IExperiment> callback) {
            super(name);
            this.project = project;
            this.experimentManager = experimentManager;
            this.experiment = experiment;
            this.callback = callback;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ExperimentActivator.activate(monitor, this.project, this.experimentManager, this.experiment, this.callback);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
                this.project = null;
                this.experimentManager = null;
                this.experiment = null;
            }
        }
    }
}

