/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentUtil;
import org.simantics.simulation.model.IModel;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.ui.handlers.ExperimentActivator;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityAction;

public class ActivateExperimentAction
implements IDoubleClickAction {
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        final Resource experiment = ResourceAdaptionUtils.toSingleResource((Object)e.getResource());
        if (experiment == null) {
            return;
        }
        if (g.isInstanceOf(experiment, SimulationResource.getInstance((ReadGraph)g).Experiment)) {
            final IProject project = Simantics.getProject();
            if (project == null) {
                return;
            }
            IModel model = ExperimentUtil.getIModel((ReadGraph)g, (Resource)experiment);
            if (model == null) {
                return;
            }
            final IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
            if (experimentManager != null) {
                e.add((IPriorityAction)new PriorityAction(1010){

                    public void run() {
                        ExperimentActivator.scheduleActivation((RequestProcessor)project.getSession(), project, experimentManager, experiment);
                    }
                });
                e.consume();
                return;
            }
        }
    }
}

