/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers.e4;

import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

/**
 * @author Tuukka Lehtonen
 * @since 1.39.0
 */
class WorkbenchUtil {

    public static boolean setMenuItemSelected(EModelService modelService, MApplication application, String toolItemId, String menuItemId, boolean selected) {
        MToolItem toolItem = (MToolItem) modelService.find(toolItemId, application);
        if (toolItem != null) {
            MMenu menu = toolItem.getMenu();
            if (menu != null) {
                MItem menuItem = (MItem) modelService.find(menuItemId, menu);
                if (menuItem != null) {
                    menuItem.setSelected(selected);
                    return true;
                }
            }
        }
        return false;
    }

}
