/*******************************************************************************
 * Copyright (c) 2007, 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - gitlab #384
 *******************************************************************************/
package org.simantics.simulation.ui.e4;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.ui.PlatformUI;
import org.simantics.simulation.SimulationEvents;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperimentListener;

public class ExperimentListener implements IExperimentListener {

    private IEventBroker eventBroker;

    public ExperimentListener() {
        eventBroker = E4Workbench.getServiceContext().get(IEventBroker.class);
    }

    @Override
    public void stateChanged(final ExperimentState state) {
        if (!PlatformUI.isWorkbenchRunning())
            return;

        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            switch (state) {
                case RUNNING:
                    eventBroker.post(SimulationEvents.TOPIC_STATE_RUNNING, true);
                    break;
                case STOPPED:
                default:
                    eventBroker.post(SimulationEvents.TOPIC_STATE_STOPPED, false);
                    break;
            }
        });
    }

}
