/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.simantics.simulation.ui";

	// The shared instance
	private static Activator plugin;

	public static ImageDescriptor PLAY_ICON;
	public static ImageDescriptor PLAY_HOVER_ICON;
	public static ImageDescriptor PAUSE_ICON;
	public static ImageDescriptor PAUSE_HOVER_ICON;

	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;

		Bundle bundle = context.getBundle();

		PLAY_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/control_play.png"));
		PLAY_HOVER_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/control_play_blue.png"));
		PAUSE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/control_pause.png"));
		PAUSE_HOVER_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/control_pause_blue.png"));
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

}
