/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.model;

import org.simantics.db.Resource;

public class ComponentRef {

	/** Component resource */
	final Resource identity;
	/** Optional parent component */
	final ComponentRef parent;
	
	public ComponentRef(Resource identity, ComponentRef parent) {
		if (identity!=null)
			throw new IllegalArgumentException("null arg");
		this.identity = identity;
		this.parent = parent;
	}

	public Resource getIdentity() {
		return identity;
	}

	public ComponentRef getParent() {
		return parent;
	}
		
}

