package org.simantics.selectionview;

import java.util.Collection;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;

public class VariableTabContribution implements TabContribution<Variable> {

	private final Resource configuration;

	public VariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		this.configuration = configuration;
	}

	@Override
	public boolean accept(ReadGraph graph, Object input) {
		return (input instanceof Variable);
	}

	@Override
	public void contribute(ReadGraph graph, final Variable variable, Collection<ComparableTabContributor> result) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);

		Resource view = graph.getPossibleObject(configuration, SEL.VariableTabContribution_HasView);
		if(view == null) throw new DatabaseException("No view for " + graph.getPossibleURI(configuration));

		Integer priority = graph.getPossibleRelatedValue(configuration, SEL.VariableTabContribution_HasPriority, Bindings.INTEGER);
		String label = graph.getPossibleRelatedValue(configuration, L0.HasLabel);
		
		for(Resource r : graph.getObjects(configuration, SEL.VariableTabContribution_HasTest)) {
			Boolean pass = Functions.exec(graph, r, graph, variable);
			if(!Boolean.TRUE.equals(pass)) return;
		}
		
		Variable configurationVariable = Variables.getVariable(graph, configuration);
		@SuppressWarnings("rawtypes")
		Function f = configurationVariable.getPossiblePropertyValue(graph, SEL.AbstractVariableTabContribution_testFunction);
		if(f != null) {
			Boolean pass = Simantics.<Boolean>applySCLRead(graph, f, variable);
			if(!Boolean.TRUE.equals(pass)) return;
		}

		final String viewURI = graph.getPossibleURI(view);
		if (viewURI != null) {
			result.add(new ComparableTabContributor(new ModelledViewTabContributor(viewURI), priority, variable, label));
		}
	}

}
