package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.ModelingResources;

public class VariablePropertyCategoryRule implements ChildRule {

	final private ArrayList<String> requiredProperties = new ArrayList<String>();
	final Resource rule;
	
	public VariablePropertyCategoryRule(ReadGraph graph, Resource rule) throws DatabaseException {

		ModelingResources MOD = ModelingResources.getInstance(graph);
		for(Resource r : graph.getObjects(rule, MOD.ModelingBrowseContext_VariablePropertyRule_RequireProperty)) {
			String name = graph.getValue(r, Bindings.STRING);
			requiredProperties.add(name);
		}
		
		this.rule = rule;
		
	}
	
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
    	
    	HashSet<CategoryNode> result = new HashSet<CategoryNode>();

    	props: for(Variable property : ((Variable)parent).getProperties(graph)) {

    		for(String req : requiredProperties) {
    			if(property.getPossibleProperty(graph, req) == null) continue props;
    		}
    		
    		Variable info = property.getPossibleProperty(graph, SelectionVariables.PROPERTY_INFO);
    		if(info != null) {
    			
	    		Variable special = SelectionViewUtils.getSpecialCategory(graph, rule, info);
	    		if(special != null) info = special;
    			
    			Boolean hidden = info.getPossiblePropertyValue(graph, SelectionVariables.CATEGORY_HIDDEN, Bindings.BOOLEAN);
    			if(hidden != null && hidden) continue;
    			String name = info.getPossiblePropertyValue(graph, SelectionVariables.CATEGORY_NAME, Bindings.STRING);
    			if(name == null) continue;
    			String sortName = info.getPossiblePropertyValue(graph, SelectionVariables.CATEGORY_SORTING_NAME, Bindings.STRING);
    			result.add(new CategoryNodeImpl(name, sortName));
    			
    		}
    				
    	}
    	
        return result;
        
    }

    @Override
    public Collection<?> getParents(ReadGraph graph, Object child)
            throws DatabaseException {
        return Collections.emptyList();
    }

}
