package org.simantics.selectionview;

import java.util.Collection;
import java.util.Collections;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public class TypedVariableTabContribution implements TabContribution<Object> {

	private final Resource configuration;

	public TypedVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		this.configuration = configuration;
	}

	@Override
	public boolean accept(ReadGraph graph, Object input) {
		return true;
//		return (input instanceof Variable);
	}
	
	private Variable getPossibleVariable(ReadGraph graph, Object input) throws DatabaseException {

		if(input instanceof Variable) {
			return (Variable)input;
		} else {
			return WorkbenchSelectionUtils.getPossibleVariable(graph, input);
		}
		
	}
	
	@Override
	public void contribute(ReadGraph graph, final Object object, Collection<ComparableTabContributor> result) throws DatabaseException {
		
		Variable variable = getPossibleVariable(graph, object);
		if(variable == null) return;
		
		Layer0 L0 = Layer0.getInstance(graph);
		SelectionViewResources SEL = SelectionViewResources.getInstance(graph);
		Collection<Resource> types = graph.getObjects(configuration, SEL.TypedVariableTabContribution_HasType);
		if(types.isEmpty()) throw new DatabaseException("No type for " + graph.getPossibleURI(configuration));
		Resource view = graph.getPossibleObject(configuration, SEL.VariableTabContribution_HasView);
		if(view == null) {
			throw new DatabaseException("No view for " + graph.getPossibleURI(configuration));
		}
		Integer priority = graph.getPossibleRelatedValue(configuration, SEL.VariableTabContribution_HasPriority, Bindings.INTEGER);
		String label = graph.getPossibleRelatedValue(configuration, L0.HasLabel);
		final String viewURI = graph.getPossibleURI(view);
		if (viewURI == null)
			return;

        Resource resource = variable.getPossibleRepresents(graph);
        if (resource == null)
            return;

        Collection<Resource> ts = graph.getTypes(resource);
        
        if (!Collections.disjoint(types, ts)) {

    		for(Resource r : graph.getObjects(configuration, SEL.VariableTabContribution_HasTest)) {
    			Boolean pass = Functions.exec(graph, r, graph, variable);
    			if(!Boolean.TRUE.equals(pass)) return;
    		}
    		
    		try {
    			Variable transformed = Simantics.tryInvokeSCL(graph, configuration, SEL.VariableTabContribution_transformation, variable);
    			if(transformed != null) variable = transformed;
    		} catch (DatabaseException e) {
    			// Errors are just ignored
    		}
        	
        	result.add(new ComparableTabContributor(new ModelledViewTabContributor(viewURI), priority, variable, label));

        }

	}

}
