/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import java.util.Collection;

/**
 * A selection processor is an interface for encapsulating the conversion from a
 * UI selection into a collection of input objects. Minimally a selection
 * processor must simply transfer the incoming selection's contents into a
 * collection. The point of having this interface is to allow contribution-based
 * preprocessing of UI selections into proper domain-specific model objects that
 * the domain-specific UI components can take as their inputs.
 * 
 * <p>
 * This interface is used in conjunction with UI components that are meant to
 * react to external inputs/UI selections. A tabbed selection view is an example
 * of such a UI component. One or more tabs are created for each preprocessed
 * input object. A selection processor in a tabbed property table is the party
 * that decides how to process/adapt a new workbench selection before sending it
 * on to property contributors for resolving all potential property tab
 * contributors.
 * 
 * @author Tuukka Lehtonen
 * 
 * @param <S>
 * @param <B>
 */
public interface SelectionProcessor<S, B> {

    /**
     * @param selection the incoming selection to process
     * @param backend for providing back-end access to the processor
     * @return an ordered set of
     *         <code>org.simantics.browsing.ui.swt.ComparableTabContributor</code>
     *         instances representing the property tabs to be contributed to the
     *         selection view. The processor must not return <code>null</code>,
     *         return an empty collection instead.
     */
    Collection<?> process(S selection, B backend);

}
