package org.simantics.selectionview;

import java.util.Objects;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.db.exception.DatabaseException;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelledViewTabContributor extends ModelledTabContributor {

	private static final Logger LOGGER = LoggerFactory.getLogger(ModelledViewTabContributor.class);

	private final String viewURI;

	public ModelledViewTabContributor(String viewURI) {
		this.viewURI = viewURI;
	}

	@Override
	public void createControls(Composite body, IWorkbenchSite site) {
		try {
			final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, site);
			SWTRoot root = loader.load(viewURI, runtime);
			root.createControls(body);
			body.addListener(SWT.Dispose, e -> {
				if(!loader.isDisposed())
					loader.dispose();
			});
		} catch (DatabaseException e) {
			LOGGER.error("Failed to create controls for view {} and runtime {}", viewURI, runtime, e);
		}
	}

	@Override
	public int hashCode() {
		return viewURI.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ModelledViewTabContributor other = (ModelledViewTabContributor) obj;
		return Objects.equals(viewURI, other.viewURI);
	}

}