package org.simantics.selectionview;

import org.simantics.databoard.Datatypes;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantValueStandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.ModelledVariablePropertyDescriptor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

public class DisplayPropertyVariableAdapter extends SimpleContextualAdapter<Variable, ModelledVariablePropertyDescriptor> {
	
    public String getDisplayProperty(ReadGraph graph, Variable property) throws DatabaseException {
    	Resource predicate = property.getPossiblePredicateResource(graph);
    	if(predicate == null) return property.getName(graph);
    	return Variables.getVariable(graph, graph.getURI(predicate)).getLabel(graph);
//        Variable predicate = property.getPossiblePropertyValue(graph, Variables.PREDICATE);
//        if(predicate == null) return property.getName(graph);
//        else return predicate.getPropertyValue(graph, Variables.LABEL);
    }
	
	@Override
	public Variable adapt(ReadGraph graph, Resource source, ModelledVariablePropertyDescriptor context) throws DatabaseException {
		
    	String value = getDisplayProperty(graph, context.getVariable());
    	return new ConstantValueStandardGraphPropertyVariable(graph, context.getVariable(), 
    			context.getSubject(),
    			SelectionViewResources.getInstance(graph).HasDisplayProperty,
    			value != null ? value : "", Datatypes.STRING);
		
	}

}
