/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.modulebrowser;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.scl.ui.Activator;

public class CreateModuleAction {
    public static final String PREFIX = "reference:file:/";

    public static final void createModule(Bundle bundle, String packageName, String moduleName) throws IOException {
        String bundleLocation = bundle.getLocation();
        bundleLocation = bundleLocation.substring(PREFIX.length());
        Path packagePath = Paths.get(bundleLocation, new String[0]).resolve("scl").resolve(packageName);
        Files.createDirectories(packagePath, new FileAttribute[0]);
        Path modulePath = packagePath.resolve(moduleName + ".scl");
        if (Files.exists(modulePath, new LinkOption[0])) {
            return;
        }
        Files.createFile(modulePath, new FileAttribute[0]);
    }

    public static THashMap<String, Bundle> findGoodBundles() {
        BundleContext context = Activator.getInstance().getBundle().getBundleContext();
        THashMap result = new THashMap();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path bundlePath;
            Bundle bundle = bundleArray[n2];
            String location = bundle.getLocation();
            if (!location.endsWith(".jar") && location.startsWith(PREFIX) && Files.isDirectory(bundlePath = Paths.get(location = location.substring(PREFIX.length()), new String[0]), new LinkOption[0])) {
                result.put((Object)bundle.getSymbolicName(), (Object)bundle);
            }
            ++n2;
        }
        return result;
    }

    public static String findBestPlugin(THashMap<String, Bundle> bundles, String packageName) {
        for (Bundle bundle : bundles.values()) {
            String location = bundle.getLocation();
            Path packagePath = Paths.get(location = location.substring(PREFIX.length()), new String[0]).resolve("scl").resolve(packageName);
            if (!Files.exists(packagePath, new LinkOption[0])) continue;
            return bundle.getSymbolicName();
        }
        int p = packageName.lastIndexOf(47);
        if (p == -1) {
            return "";
        }
        return CreateModuleAction.findBestPlugin(bundles, packageName.substring(0, p));
    }

    public static int packageMatchLength(Bundle bundle, String packageName) {
        if (bundle.getEntry("scl") == null) {
            return 0;
        }
        packageName = "scl/" + (String)packageName;
        while (((String)packageName).length() > 3) {
            if (bundle.getEntry((String)packageName) != null) {
                return ((String)packageName).length();
            }
            int p = ((String)packageName).lastIndexOf(47);
            packageName = ((String)packageName).substring(0, p);
        }
        return 3;
    }
}

