/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor.completion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;

public class SCLCompletionAssistProcessor
implements IContentAssistProcessor {
    private String lastError = "";
    private SCLTextEditorEnvironment sclTextEditorEnvironment;
    private static final char[] AUTO_ACTIVATION_CHARS = new char[]{'.', '('};

    public SCLCompletionAssistProcessor(SCLTextEditorEnvironment sclTextEditorEnvironment) {
        this.sclTextEditorEnvironment = sclTextEditorEnvironment;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int tmpOffset) {
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == tmpOffset) {
            tmpOffset = selection.getOffset() + selection.getLength();
        }
        int offset = tmpOffset;
        IDocument document = viewer.getDocument();
        String tmpPrefix = "";
        try {
            tmpPrefix = SCLCompletionAssistProcessor.getPrefix(document, offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.sclTextEditorEnvironment.updateEnvironment(document);
        return this.sclTextEditorEnvironment.getCompletionProposals(tmpPrefix, offset);
    }

    private static String getPrefix(IDocument doc, int offset) throws BadLocationException {
        int docLen = doc.getLength();
        if (doc == null || offset > docLen || docLen == 0) {
            return "";
        }
        int length = 0;
        while (--offset >= 0 && Character.isJavaIdentifierPart(doc.getChar(offset)) || doc.getChar(offset) == '.') {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return AUTO_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.lastError;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

