/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.console;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.console.Messages;
import org.simantics.scl.ui.console.Preferences;

public class SCLConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor2 fUseBufferSize = null;
    private ConsoleIntegerFieldEditor fBufferSizeEditor = null;

    public SCLConsolePreferencePage() {
        super(1);
        this.setDescription(Messages.SCLConsolePreferencePage_Description);
        this.setPreferenceStore(Activator.getInstance().getPreferenceStore());
    }

    public void createFieldEditors() {
        this.fUseBufferSize = new BooleanFieldEditor2("SCLConsole.limitConsoleOutput", Messages.SCLConsolePreferencePage_Limit_console_output_Label, 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fUseBufferSize);
        this.fBufferSizeEditor = new ConsoleIntegerFieldEditor("SCLConsole.lowWaterMark", Messages.SCLConsolePreferencePage_Console_buffer_size_Label, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fBufferSizeEditor);
        this.fBufferSizeEditor.setValidRange(1000, 10000000);
        this.fBufferSizeEditor.setErrorMessage(Messages.SCLConsolePreferencePage_Console_buffer_size_Error);
        this.fUseBufferSize.getChangeControl(this.getFieldEditorParent()).addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateBufferSizeEditor()));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IPreferenceStore store = Activator.getInstance().getPreferenceStore();
        int low = store.getInt("SCLConsole.lowWaterMark");
        store.setValue("SCLConsole.highWaterMark", Preferences.highWatermarkForLow(low));
        return ok;
    }

    protected void initialize() {
        super.initialize();
        this.updateBufferSizeEditor();
    }

    protected void updateBufferSizeEditor() {
        Button b = this.fUseBufferSize.getChangeControl(this.getFieldEditorParent());
        this.fBufferSizeEditor.getTextControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
        this.fBufferSizeEditor.getLabelControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateBufferSizeEditor();
    }

    protected boolean canClearErrorMessage() {
        return this.fBufferSizeEditor.isValid();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this.fBufferSizeEditor != null && event.getSource() != this.fBufferSizeEditor) {
                    this.fBufferSizeEditor.refreshValidState();
                }
                this.checkState();
            } else {
                super.propertyChange(event);
            }
        } else {
            super.propertyChange(event);
        }
    }

    public class BooleanFieldEditor2
    extends BooleanFieldEditor {
        private Button fChangeControl;

        public BooleanFieldEditor2(String name, String labelText, int style, Composite parent) {
            super(name, labelText, style, parent);
        }

        public Button getChangeControl(Composite parent) {
            if (this.fChangeControl == null) {
                this.fChangeControl = super.getChangeControl(parent);
            }
            return this.fChangeControl;
        }
    }

    protected class ConsoleIntegerFieldEditor
    extends IntegerFieldEditor {
        public ConsoleIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (SCLConsolePreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

