/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.browser;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.markdown.html.GenerateAllHtmlDocumentation;
import org.simantics.scl.compiler.markdown.html.HierarchicalDocumentationRef;
import org.simantics.scl.compiler.markdown.html.HtmlDocumentationGeneration;
import org.simantics.scl.compiler.markdown.internal.HtmlEscape;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.browser.Messages;
import org.simantics.scl.ui.browser.SCLDefinitionSelectionDialog;

public class SCLDocumentationBrowser {
    public static final String STANDARD_LIBRARY = "StandardLibrary";
    Browser browser;
    Button backButton;
    Text pageName;
    Button refreshButton;
    Button forwardButton;
    String currentPageName = "";
    Button saveButton;
    Button findButton;
    Tree navigationTree;
    ArrayList<String> locationHistory = new ArrayList();
    int locationHistoryPosition = -1;
    ArrayList<Runnable> runWhenCompleted = new ArrayList(2);
    Object runWhenCompletedLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWhenCompleted(final String script) {
        Object object = this.runWhenCompletedLock;
        synchronized (object) {
            this.runWhenCompleted.add(new Runnable(){

                @Override
                public void run() {
                    SCLDocumentationBrowser.this.browser.execute(script);
                }
            });
        }
    }

    private void newLocation(String location) {
        if (this.locationHistoryPosition < 0 || !location.equals(this.locationHistory.get(this.locationHistoryPosition))) {
            ++this.locationHistoryPosition;
            while (this.locationHistory.size() > this.locationHistoryPosition) {
                this.locationHistory.remove(this.locationHistory.size() - 1);
            }
            this.locationHistory.add(location);
            this.updateButtons();
        }
    }

    private void back() {
        if (this.locationHistoryPosition > 0) {
            this.browser.setUrl(this.locationHistory.get(--this.locationHistoryPosition));
            this.updateButtons();
        }
    }

    private void refresh() {
        SCLOsgi.SOURCE_REPOSITORY.checkUpdates();
        Object yOffset = this.browser.evaluate("return window.pageYOffset !== undefined ? window.pageYOffset : ((document.compatMode || \"\") === \"CSS1Compat\") ? document.documentElement.scrollTop : document.body.scrollTop;");
        if (yOffset != null) {
            this.executeWhenCompleted("window.scroll(0," + String.valueOf(yOffset) + ");");
        }
        this.browser.setUrl(this.locationHistory.get(this.locationHistoryPosition));
        this.updateNavigationTree();
    }

    private void forward() {
        if (this.locationHistoryPosition < this.locationHistory.size() - 1) {
            this.browser.setUrl(this.locationHistory.get(++this.locationHistoryPosition));
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.backButton.setEnabled(this.locationHistoryPosition > 0);
        this.forwardButton.setEnabled(this.locationHistoryPosition < this.locationHistory.size() - 1);
    }

    private void setCurrentLocation(String location) {
        this.pageName.setText(location);
        this.currentPageName = location;
    }

    public SCLDocumentationBrowser(Composite parent) {
        Color white = parent.getDisplay().getSystemColor(1);
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(composite);
        composite.setBackground(white);
        Composite buttons = new Composite(composite, 0);
        buttons.setBackground(white);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().numColumns(6).margins(3, 3).applyTo(buttons);
        this.backButton = new Button(buttons, 8);
        buttons.setBackground(composite.getDisplay().getSystemColor(15));
        this.backButton.setToolTipText(Messages.SCLDocumentationBrowser_BackTT);
        this.backButton.setEnabled(false);
        this.backButton.setImage(Activator.getInstance().getImageRegistry().get("arrow_left"));
        this.forwardButton = new Button(buttons, 8);
        this.forwardButton.setToolTipText(Messages.SCLDocumentationBrowser_ForwardTT);
        this.forwardButton.setEnabled(false);
        this.forwardButton.setImage(Activator.getInstance().getImageRegistry().get("arrow_right"));
        this.refreshButton = new Button(buttons, 8);
        this.refreshButton.setToolTipText(Messages.SCLDocumentationBrowser_RefreshPageTT);
        this.refreshButton.setImage(Activator.getInstance().getImageRegistry().get("arrow_refresh"));
        this.pageName = new Text(buttons, 2052);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.pageName);
        this.findButton = new Button(buttons, 8);
        this.findButton.setToolTipText(Messages.SCLDocumentationBrowser_FindSCLDefinitionTT);
        this.findButton.setImage(Activator.getInstance().getImageRegistry().get("find"));
        this.saveButton = new Button(buttons, 8);
        this.saveButton.setToolTipText(Messages.SCLDocumentationBrowser_SaveDocumentationToDiskTT);
        this.saveButton.setImage(Activator.getInstance().getImageRegistry().get("disk"));
        SashForm browserBox = new SashForm(composite, 2304);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)browserBox);
        browserBox.setLayout((Layout)new FillLayout());
        this.navigationTree = new Tree((Composite)browserBox, 4);
        this.updateNavigationTree();
        this.navigationTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String documentationName;
                TreeItem[] items = SCLDocumentationBrowser.this.navigationTree.getSelection();
                if (items.length == 1 && (documentationName = (String)items[0].getData()) != null) {
                    SCLDocumentationBrowser.this.setLocation(documentationName);
                }
            }
        });
        this.browser = new Browser((Composite)browserBox, 2048);
        browserBox.setWeights(new int[]{15, 85});
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(ProgressEvent event) {
                ArrayList<Runnable> rs;
                Object object = SCLDocumentationBrowser.this.runWhenCompletedLock;
                synchronized (object) {
                    rs = SCLDocumentationBrowser.this.runWhenCompleted;
                    SCLDocumentationBrowser.this.runWhenCompleted = new ArrayList(2);
                }
                for (Runnable r : rs) {
                    r.run();
                }
            }
        });
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (location.startsWith("about:blank")) {
                    return;
                }
                SCLDocumentationBrowser.this.newLocation(location);
                if (location.startsWith("about:")) {
                    String fragment;
                    location = location.substring(6);
                    SCLDocumentationBrowser.this.setCurrentLocation(location);
                    int hashPos = location.indexOf(35);
                    if (hashPos >= 0) {
                        fragment = location.substring(hashPos);
                        location = location.substring(0, hashPos);
                    } else {
                        fragment = null;
                    }
                    if (location.endsWith(".html")) {
                        location = location.substring(0, location.length() - 5);
                    }
                    String html = HtmlDocumentationGeneration.generate((ModuleRepository)SCLOsgi.MODULE_REPOSITORY, (String)location, null);
                    SCLDocumentationBrowser.this.browser.setText(html);
                    if (fragment != null) {
                        SCLDocumentationBrowser.this.executeWhenCompleted("location.hash = \"" + fragment + "\";");
                    }
                    event.doit = false;
                } else {
                    SCLDocumentationBrowser.this.setCurrentLocation(location);
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x10000) != 0) {
                    if (e.keyCode == 0x1000003) {
                        SCLDocumentationBrowser.this.back();
                        return;
                    }
                    if (e.keyCode == 0x1000004) {
                        SCLDocumentationBrowser.this.forward();
                        return;
                    }
                } else if ((e.stateMask & 0x40000) != 0) {
                    if (e.keyCode == 114 || e.keyCode == 82) {
                        SCLDocumentationBrowser.this.refresh();
                        return;
                    }
                    if (e.keyCode == 108 || e.keyCode == 76) {
                        SCLDocumentationBrowser.this.pageName.selectAll();
                        SCLDocumentationBrowser.this.pageName.setFocus();
                        return;
                    }
                    if (e.keyCode == 107 || e.keyCode == 75) {
                        SCLDocumentationBrowser.this.pageName.setText("?");
                        SCLDocumentationBrowser.this.pageName.setSelection(1);
                        SCLDocumentationBrowser.this.pageName.setFocus();
                        return;
                    }
                    if (e.keyCode == 104 || e.keyCode == 72) {
                        SCLDocumentationBrowser.this.find();
                        return;
                    }
                }
                if (e.keyCode == 0x1000006) {
                    SCLDocumentationBrowser.this.browser.execute("window.scrollBy(0,0.8*(window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight));");
                } else if (e.keyCode == 0x1000005) {
                    SCLDocumentationBrowser.this.browser.execute("window.scrollBy(0,-0.8*(window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight));");
                } else if (e.keyCode == 0x1000002) {
                    SCLDocumentationBrowser.this.browser.execute("window.scrollBy(0,100);");
                } else if (e.keyCode == 0x1000001) {
                    SCLDocumentationBrowser.this.browser.execute("window.scrollBy(0,-100);");
                } else if (e.keyCode == 0x1000007) {
                    if (e.widget != SCLDocumentationBrowser.this.pageName) {
                        SCLDocumentationBrowser.this.browser.execute("window.scroll(0,0);");
                    }
                } else if (e.keyCode == 0x1000008 && e.widget != SCLDocumentationBrowser.this.pageName) {
                    SCLDocumentationBrowser.this.browser.execute("window.scroll(0,document.body.scrollHeight);");
                }
            }
        };
        composite.addKeyListener((KeyListener)keyListener);
        this.browser.addKeyListener((KeyListener)keyListener);
        this.pageName.addKeyListener((KeyListener)keyListener);
        MouseWheelListener wheelListener = new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                SCLDocumentationBrowser.this.browser.execute("window.scrollBy(0," + e.count * -30 + ");");
            }
        };
        composite.addMouseWheelListener(wheelListener);
        this.browser.addMouseWheelListener(wheelListener);
        this.backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCLDocumentationBrowser.this.back();
            }
        });
        this.forwardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCLDocumentationBrowser.this.forward();
            }
        });
        this.refreshButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SCLDocumentationBrowser.this.refresh();
            }
        });
        this.pageName.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    SCLDocumentationBrowser.this.setLocation(SCLDocumentationBrowser.this.pageName.getText());
                } else if (e.detail == 2) {
                    SCLDocumentationBrowser.this.pageName.setText(SCLDocumentationBrowser.this.currentPageName);
                }
            }
        });
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCLDocumentationBrowser.this.find();
            }
        });
        this.saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SCLDocumentationBrowser.this.saveButton.getShell());
                dialog.setText(Messages.SCLDocumentationBrowser_SaveDocumentationDialog_Title);
                dialog.setMessage(Messages.SCLDocumentationBrowser_SaveDocumentationDialog_Msg);
                String directory = dialog.open();
                if (directory != null) {
                    try {
                        GenerateAllHtmlDocumentation.generate((ModuleRepository)SCLOsgi.MODULE_REPOSITORY, (Path)Paths.get(directory, new String[0]));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        ErrorDialog.openError((Shell)SCLDocumentationBrowser.this.saveButton.getShell(), (String)"Documentation generation failed", null, (IStatus)new Status(4, "org.simantics.scl.ui", 0, ex.toString(), (Throwable)ex));
                    }
                }
            }
        });
    }

    private void find() {
        SCLValue value;
        SCLDefinitionSelectionDialog dialog = new SCLDefinitionSelectionDialog(this.findButton.getShell());
        if (dialog.open() == 0 && (value = (SCLValue)dialog.getFirstResult()) != null) {
            this.setLocation(value.getName().module + "#" + String.valueOf(HtmlEscape.escape((CharSequence)value.getName().name)));
        }
    }

    private static ExpStatus getExpStatus(Tree tree) {
        ExpStatus status = new ExpStatus();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (child.getExpanded()) {
                status.expandedItems.put((Object)child.getText(), (Object)SCLDocumentationBrowser.getExpStatus(child));
            }
            ++n2;
        }
        return status;
    }

    private static ExpStatus getExpStatus(TreeItem item) {
        ExpStatus status = new ExpStatus();
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (child.getExpanded()) {
                status.expandedItems.put((Object)child.getText(), (Object)SCLDocumentationBrowser.getExpStatus(child));
            }
            ++n2;
        }
        return status;
    }

    private static void setExpStatus(Tree tree, ExpStatus status) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            ExpStatus childStatus = (ExpStatus)status.expandedItems.get((Object)child.getText());
            if (childStatus != null) {
                child.setExpanded(true);
                SCLDocumentationBrowser.setExpStatus(child, childStatus);
            }
            ++n2;
        }
    }

    private static void setExpStatus(TreeItem item, ExpStatus status) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            ExpStatus childStatus = (ExpStatus)status.expandedItems.get((Object)child.getText());
            child.setExpanded(true);
            if (childStatus != null) {
                SCLDocumentationBrowser.setExpStatus(child, childStatus);
            }
            ++n2;
        }
    }

    private void updateNavigationTree() {
        HierarchicalDocumentationRef root = HierarchicalDocumentationRef.generateTree((ModuleSourceRepository)SCLOsgi.SOURCE_REPOSITORY);
        ExpStatus status = SCLDocumentationBrowser.getExpStatus(this.navigationTree);
        this.navigationTree.removeAll();
        for (HierarchicalDocumentationRef navItem : root.getChildren()) {
            TreeItem item = new TreeItem(this.navigationTree, 0);
            this.configureTreeItem(navItem, item);
        }
        SCLDocumentationBrowser.setExpStatus(this.navigationTree, status);
    }

    private void configureTreeItem(HierarchicalDocumentationRef navItem, TreeItem item) {
        item.setText(navItem.getName());
        item.setData((Object)navItem.getDocumentationName());
        for (HierarchicalDocumentationRef childNavItem : navItem.getChildren()) {
            TreeItem childItem = new TreeItem(item, 0);
            this.configureTreeItem(childNavItem, childItem);
        }
    }

    public void setLocation(String path) {
        this.browser.setUrl("about:" + path);
    }

    private static class ExpStatus {
        THashMap<String, ExpStatus> expandedItems = new THashMap();

        private ExpStatus() {
        }
    }
}

