package org.simantics.scl.ui.editor;

import java.util.HashMap;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {

	protected HashMap<RGB, Color> colorTable = new HashMap<RGB, Color>();

	public void dispose() {
		for(Color c : colorTable.values())
			c.dispose();
		colorTable.clear();
	}
	
	public Color get(RGB rgb) {
		Color color = colorTable.get(rgb);
		if (color == null) {
			color = new Color(Display.getCurrent(), rgb);
			colorTable.put(rgb, color);
		}
		return color;
	}
	
}
